package com.bxm.fossicker.commodity.service.commodity.list.impl;

import com.bxm.fossicker.commodity.model.constant.CommodityPoolId;
import com.bxm.fossicker.commodity.model.param.HomePageWellChoseCommodityListParam;
import com.bxm.fossicker.commodity.model.param.PoolCommodityListParam;
import com.bxm.fossicker.commodity.model.param.WellChoseCommodityListParam;
import com.bxm.fossicker.commodity.model.vo.CategoryCommodityListItem;
import com.bxm.fossicker.commodity.model.vo.PoolCommodityListItem;
import com.bxm.fossicker.commodity.service.commodity.list.AbstractCommodityListService;
import com.google.common.collect.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 首页精选列表
 * 包含了新人商品、置顶和精选的列表
 *
 * @Author: Gonzo
 * @date 2020-03-03 16:10
 * @since 1.6.0
 */
@Service
public class HomePageWellChoseCommodityListService extends AbstractCommodityListService<CategoryCommodityListItem,
        HomePageWellChoseCommodityListParam> {


    @Override
    protected List<CategoryCommodityListItem> doGetCommodityList(HomePageWellChoseCommodityListParam param) {

        List<CategoryCommodityListItem> listAll = Lists.newArrayList();

        // 只有第一页才查询置顶、新人首单的列表数据
        if (param.getPageOn() <= 1) {
            // 先查询 获取新人、置顶商品池数据
            List<PoolCommodityListItem> poolCommodityInfos = poolCommodityInfos(param);
            // 转换
            listAll.addAll(poolCommodityInfos.stream()
                    .map(p -> {
                        CategoryCommodityListItem searchDTO = new CategoryCommodityListItem();
                        BeanUtils.copyProperties(p, searchDTO);
                        return searchDTO;
                    }).collect(Collectors.toList()));
        }

        // 调用第三方接口 大淘客+好单库   方式为：交叉展示
        List<CategoryCommodityListItem> listOther = goodsListForWellChose(param);

        // 去重
        listOther.removeIf(p -> listAll.stream().anyMatch(p1 -> Objects.equals(p1.getGoodsId(), p.getGoodsId())));

        // 合并
        listAll.addAll(listOther);

        return listAll;
    }

    private List<CategoryCommodityListItem> goodsListForWellChose(HomePageWellChoseCommodityListParam param) {
        // 封装参数
        WellChoseCommodityListParam param1 = new WellChoseCommodityListParam();
        BeanUtils.copyProperties(param, param1);
        // 查询金币信息
        param1.setQueryGoldInfo(true);
        // 查询标签信息
        param1.setQueryLabel(true);

        // 查询列表
        return getCommodityList(param1);
    }

    private List<PoolCommodityListItem> poolCommodityInfos(HomePageWellChoseCommodityListParam param) {
        List<PoolCommodityListItem> goodsPoolListAll = new ArrayList<>();

        PoolCommodityListParam poolParam = new PoolCommodityListParam();
        BeanUtils.copyProperties(param, poolParam);

        poolParam.setPoolId(CommodityPoolId.NOVICE);
        // 需要查询金币信息
        poolParam.setQueryGoldInfo(true);
        // 查询标签信息
        poolParam.setQueryLabel(true);

        // 如果是新人 查询新人专享列表
        if (Objects.equals(param.getNewbieRight(), Boolean.TRUE)) {
            goodsPoolListAll.addAll(getCommodityList(poolParam));
        }

        poolParam.setPoolId(CommodityPoolId.TOP);
        // 置顶商品列表
        goodsPoolListAll.addAll(getCommodityList(poolParam));
        return goodsPoolListAll;
    }

    @Override
    protected String description() {
        return "首页精选列表";
    }

    @Override
    public Class<HomePageWellChoseCommodityListParam> support() {
        return HomePageWellChoseCommodityListParam.class;
    }
}
