package com.bxm.fossicker.commodity.service.commodity.list.impl;

import com.bxm.fossicker.commodity.domain.CommodityFavoriteMapper;
import com.bxm.fossicker.commodity.model.dto.CommodityListItemResult;
import com.bxm.fossicker.commodity.model.param.CommodityDetailQueryParam;
import com.bxm.fossicker.commodity.model.param.UserCollectionCommodityListParam;
import com.bxm.fossicker.commodity.model.vo.CommodityCollectionVO;
import com.bxm.fossicker.commodity.service.commodity.list.AbstractCommodityListService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 用户收藏列表
 * @Author: Gonzo
 * @date  2020-03-05 11:36
 * @since 1.6.0
 */
@Service
public class UserCollectionCommodityListService extends AbstractCommodityListService<CommodityCollectionVO,
        UserCollectionCommodityListParam> {

    @Autowired
    private CommodityFavoriteMapper commodityFavoriteMapper;

    @Override
    protected List<CommodityCollectionVO> doGetCommodityList(UserCollectionCommodityListParam param) {

        List<String> goodsIdList = commodityFavoriteMapper.getCollectionByUserId(param.getUserId());
        if (CollectionUtils.isEmpty(goodsIdList)) {
            return null;
        }

        return goodsIdList.stream()
                .map(p -> {
                    CommodityDetailQueryParam queryParam = initCommodityDetailQueryParam(param, Long.parseLong(p));

                    // 不只查询本地信息
                    queryParam.setQueryLocalOnly(false);
                    // 当校验失败时，返回基础信息
                    queryParam.setIfNotValidThenReturnBaseInfo(true);

                    CommodityListItemResult itemResult = commodityListItemBaseInfo(queryParam);

                    CommodityCollectionVO collectionVO = new CommodityCollectionVO();
                    // 校验查询结果
                    if (!checkCommodityListBaseItemSuccess(itemResult)) {
                        // 收藏列表哪怕校验失败， 但是有数据的话， 也需要吧基本数据返回
                        if (Objects.nonNull(itemResult.getListItem())) {
                            collectionVO.setCommodityTitle(itemResult.getListItem().getCommodityTitle());
                            collectionVO.setMainPic(itemResult.getListItem().getImgUrl());
                            collectionVO.setImgUrl(itemResult.getListItem().getImgUrl());
                            collectionVO.setShopName(itemResult.getListItem().getShopName());
                            collectionVO.setShopType(itemResult.getListItem().getShopType());
                            collectionVO.setGoodsId(itemResult.getListItem().getGoodsId());
                        }

                        collectionVO.setValidStatus(0);
                        return collectionVO;
                    }

                    BeanUtils.copyProperties(itemResult.getListItem(), collectionVO);

                    // 校验状态
                    collectionVO.setValidStatus(1);
                    // 主图
                    collectionVO.setMainPic(collectionVO.getImgUrl());

                    return collectionVO;
                })
                // 过滤空的
                .filter(Objects::nonNull)
                .sorted(Comparator.comparing(CommodityCollectionVO::getValidStatus).reversed())
                // 将失效的商品往后排序 需做保留-因客户端未作展示,F现方案为删除--V1.2.0
                .collect(Collectors.toList());
    }


    @Override
    protected String description() {
        return "用户收藏列表";
    }

    @Override
    public Class<UserCollectionCommodityListParam> support() {
        return UserCollectionCommodityListParam.class;
    }
}
