package com.bxm.fossicker.commodity.service.externel;

import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.taobao.api.request.TbkActivitylinkGetRequest;
import com.taobao.api.request.TbkDgMaterialOptionalRequest;
import com.taobao.api.request.TbkItemRecommendGetRequest;
import com.taobao.api.request.TbkJuTqgGetRequest;
import com.taobao.api.response.TbkActivitylinkGetResponse;
import com.taobao.api.response.TbkDgMaterialOptionalResponse;
import com.taobao.api.response.TbkItemRecommendGetResponse;
import com.taobao.api.response.TbkJuTqgGetResponse;

import java.util.List;

public interface TbCommodityService {

    /**
     * 获取商品详情-暂时只提供价格/主图/商家名称类型/月销量的数据能力
     * @param goodsId 商品id
     * @return 商品详情信息
     */
    CommodityDetailDTO getCommodityDetail(Long goodsId);

    /**
     * 批量查询商品详情-暂时只提供价格/主图/商家名称类型/月销量的数据能力
     * @param goodsIdArray 商品id串,用逗号隔开
     * @return 商品详情信息list
     */
    List<CommodityDetailDTO> getCommodityDetailList(String goodsIdArray);

    /**
     * 创建淘口令
     * @param url 跳转的url地址
     * @param logUrl 图标地址
     * @param text 显示文案
     * @return 生成的淘口令
     */
    String createTaoWord(String url, String logUrl, String text);

    /**
     * 获取淘抢购商品
     * @param req 请求参数
     * @return 请求返回值
     */
    TbkJuTqgGetResponse getTqgCommodity(TbkJuTqgGetRequest req);

    /**
     * 根据搜索名称获取列表
     * @param req 查询参数
     * @return 查询结果
     */
    TbkDgMaterialOptionalResponse getCommodityListByName(TbkDgMaterialOptionalRequest req);

    /**
     * 获取推荐商品
     * @param req 查询参数
     * @return 查询结果
     */
    TbkItemRecommendGetResponse getRecommendCommodity(TbkItemRecommendGetRequest req);

    /**
     * 获取淘宝联盟跳转地址
     * @param req
     * @return 跳转链接
     */
    TbkActivitylinkGetResponse getTaoBaoUnion(TbkActivitylinkGetRequest req);

}
