package com.bxm.fossicker.commodity.service.externel;

import com.bxm.fossicker.commodity.model.dto.WyCommissionDataDTO;
import com.bxm.fossicker.commodity.model.dto.WySearchCommodityInfoDTO;
import com.bxm.fossicker.commodity.model.dto.WySearchResultDTO;
import com.bxm.fossicker.commodity.model.param.CommoditySearchParam;
import com.bxm.fossicker.commodity.model.param.GuessCommodityQueryParam;

import java.util.List;

public interface WyCommodityService {

    /**
     * 搜索商品
     * @param commoditySearchParam 查询参数
     * @return 商品list
     */
    WySearchResultDTO searchCommodity(CommoditySearchParam commoditySearchParam);


    /**
     * 获取猜你喜欢商品
     * @param guessCommodityQueryParam 猜你喜欢请求参数
     * @return 猜你喜欢商品列表
     */
    List<WySearchCommodityInfoDTO> guessLike(GuessCommodityQueryParam guessCommodityQueryParam);

    /**
     * 获取高佣信息
     * @param goodsId 商品id
     * @return 高佣信息
     */
    WyCommissionDataDTO getCommissionInfo(Long goodsId);
}
