package com.bxm.fossicker.commodity.service.externel.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.common.utils.SignMD5Util;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.bxm.fossicker.commodity.model.dto.DtkCommodityDetailDataDTO;
import com.bxm.fossicker.commodity.model.dto.DtkResultDTO;
import com.bxm.fossicker.commodity.service.externel.DtkCommodityService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

@Service
@Slf4j
public class DtkCommodityServiceImpl implements DtkCommodityService {

    @Autowired
    private CommodityInfoProperties commodityInfoProperties;

    @Override
    public CommodityDetailDTO getCommodityDetail(Long goodsId) {

        //商品详情
        TreeMap<String,Object> paramMap = new TreeMap<>();
        paramMap.put("version",commodityInfoProperties.getDtkCommodityVersion());
        paramMap.put("appKey", commodityInfoProperties.getDtkCommodityAppKey());
        paramMap.put("goodsId", goodsId.toString());
        paramMap.put("sign", SignMD5Util.getSignStr(paramMap, commodityInfoProperties.getDtkCommodityAppSecret()));

        DtkResultDTO resultDTO = queryDtkCommodityList(commodityInfoProperties.getDtkCommodityDetailUrl(), paramMap);
        if (DtkResultDTO.isFailed(resultDTO)) {
            log.error("请求大淘客商品详情接口失败");
            return null;
        }
        DtkCommodityDetailDataDTO dtkInfo = JSON.parseObject(resultDTO.getData().toString(), DtkCommodityDetailDataDTO.class);


        List<String> picList = new ArrayList<>();
        picList.add(dtkInfo.getMainPic());
        //参数转换
        return CommodityDetailDTO.builder()
                .goodsId(goodsId)
                .reservePrice(dtkInfo.getOriginalPrice())
                .commodityTitle(dtkInfo.getTitle())
                .salesNum(dtkInfo.getMonthSales())
                .commodityScore(Objects.toString(dtkInfo.getDescScore(), null))
                .sellerScore(Objects.toString(dtkInfo.getShipScore(), null))
                .logisticsScore(Objects.toString(dtkInfo.getServiceScore(), null))
                .imgUrlList(picList)
                .shopName(dtkInfo.getShopName())
                .recommendContent(dtkInfo.getDesc())
                .shopType(dtkInfo.getShopType())
                .build();

    }

    /**
     * 请求
     *
     * @param queryUrl      请求URL
     * @param queryParamMap 请求参数map
     * @return 大淘客请求结果DTO 若请求失败或者请求结果为空 则返回null
     */
    private DtkResultDTO queryDtkCommodityList(String queryUrl, Map<String, Object> queryParamMap) {

        DtkResultDTO dtkResultDTO = null;
        String resultStr = null;
        for (int tryTimes = 1; tryTimes < 3; tryTimes++) {
            try {
                resultStr = OkHttpUtils.get(queryUrl, queryParamMap);
            } catch (IOException e) {
                log.error("根据参数请求大淘客商品列表异常,请求参数:{},异常:{}", JSON.toJSONString(queryParamMap), e);
            }

            if (StringUtils.isBlank(resultStr)) {
                continue;
            }

            dtkResultDTO = JSON.parseObject(resultStr, DtkResultDTO.class);
            if (null != dtkResultDTO && 0 == dtkResultDTO.getCode()) {
                break;
            }

        }
        return dtkResultDTO;

    }
}
