package com.bxm.fossicker.commodity.service.externel.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.HdkCommissionDataDTO;
import com.bxm.fossicker.commodity.model.dto.HdkCommodityDetailDataDTO;
import com.bxm.fossicker.commodity.model.dto.HdkResultDTO;
import com.bxm.fossicker.commodity.service.externel.HdkCommodityService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class HdkCommodityServiceImpl implements HdkCommodityService {

    /**
     * 商品信息配置项
     */
    @Autowired
    private CommodityInfoProperties commodityInfoProperties;

    @Override
    public HdkCommissionDataDTO getCommissionAndCoupon(Long goodsId,String pid) {


        Map<String, Object> paramMap = new HashMap<>(4);
        paramMap.put("apikey", commodityInfoProperties.getHdkCommodityAppKey());
        paramMap.put("itemid", goodsId.toString());
        paramMap.put("pid", pid);

        String httpResult = queryHttpPostWithRetry(commodityInfoProperties.getHdkCommodityUrl(), paramMap);
        if (StringUtils.isBlank(httpResult)) {
            log.error("请求高佣接口失败,商品id为:{}", goodsId);
            return null;
        }

        HdkResultDTO hdkResultDTO = JSON.parseObject(httpResult, HdkResultDTO.class);
        if (HdkResultDTO.isFailed(hdkResultDTO)) {
            log.error("请求高佣接口失败,商品id为:{},错误信息为:{}", goodsId, hdkResultDTO.getMsg());
            return null;
        }

        return JSON.parseObject(hdkResultDTO.getData().toString(),
                HdkCommissionDataDTO.class);
    }

    @Override
    public Double getPriceInfo(Long goodsId) {
        if (null == goodsId) {
            log.error("请求商品价格信息,商品id不能为空");
            return null;
        }

        String url = commodityInfoProperties.getHdkCommodityDetailUrl();
        String finalUrl = MessageFormat.format(url, commodityInfoProperties.getHdkCommodityAppKey(), goodsId.toString());


        String httpResult = null;
        try {
            httpResult = OkHttpUtils.get(finalUrl);
        } catch (IOException e) {
            e.printStackTrace();
        }

        if (StringUtils.isBlank(httpResult)) {
            log.error("请求好单库数据为空,请求url:{}", url);
            return null;
        }

        HdkResultDTO hdkResultDTO = JSONObject.parseObject(httpResult, HdkResultDTO.class);
        if (HdkResultDTO.isFailed(hdkResultDTO)) {
            log.error("请求好单库数据失败,请求url:{},错误信息为:{}", finalUrl, hdkResultDTO.getMsg());
            return null;
        }

        HdkCommodityDetailDataDTO hdkCommodityDetailDataDTO =
                JSONObject.parseObject(hdkResultDTO.getData().toString(), HdkCommodityDetailDataDTO.class);

        return Double.valueOf(hdkCommodityDetailDataDTO.getItemprice());
    }


    private String queryHttpPostWithRetry(String queryUrl, Map<String, Object> queryParamMap) {

        String resultStr = null;
        for (int tryTimes = 1; tryTimes < 3; tryTimes++) {
            try {
                resultStr = OkHttpUtils.postForm(queryUrl, queryParamMap);
            } catch (Exception e) {
                log.error("根据参数请求http接口异常,请求参数:{},异常:{}", JSON.toJSONString(queryParamMap), e);
            }

            if (org.apache.commons.lang3.StringUtils.isNotBlank(resultStr)) {
                return resultStr;
            }
        }
        return resultStr;

    }
}
