package com.bxm.fossicker.commodity.service.externel.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.service.externel.QueryWithRetryService;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.Map;

@Service
@Slf4j
public class QueryWithRetryServiceImpl implements QueryWithRetryService {

    @Override
    @Retryable(value = {IOException.class}, maxAttempts = 3, backoff = @Backoff(value = 50))
    public String doGetWithRetry(String queryUrl, Map<String, Object> paramMap) throws Exception {

        String searchResultStr;
        try {
            searchResultStr = OkHttpUtils.get(queryUrl, paramMap);
        } catch (IOException e) {
            log.error("请求异常,请求路径为:{}, 请求参数为:{}, 异常为:{}", queryUrl, JSON.toJSONString(paramMap), e);
            throw new Exception();
        }
        if (StringUtils.isBlank(searchResultStr)) {
            throw new Exception("请求结果为空");
        }
        return searchResultStr;
    }
}
