package com.bxm.fossicker.commodity.service.externel.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.bxm.fossicker.commodity.service.externel.TbCommodityService;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.request.*;
import com.taobao.api.response.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service
@Slf4j
public class TbCommodityServiceImpl implements TbCommodityService {


    @Autowired
    private CommodityInfoProperties commodityInfoProperties;

    @Override
    public CommodityDetailDTO getCommodityDetail(Long goodsId) {


        TaobaoClient client = new DefaultTaobaoClient(commodityInfoProperties.getTbCommodityUrl(),
                commodityInfoProperties.getTbCommodityAppKey(), commodityInfoProperties.getTbCommodityAppSecret());


        TbkItemInfoGetRequest req = new TbkItemInfoGetRequest();
        req.setNumIids(goodsId.toString());

        TbkItemInfoGetResponse rsp;
        try {
            rsp = client.execute(req);
        } catch (ApiException e) {
            log.error("从淘宝接口获取商品详情异常,商品id为:{},异常为:", goodsId, e);
            return null;
        }

        if (null == rsp || !rsp.isSuccess() || CollectionUtils.isEmpty(rsp.getResults())) {
            log.error("从淘宝接口获取到的商品列表信息为空,商品id为:{}", goodsId);
            return null;
        }
        TbkItemInfoGetResponse.NTbkItem tbInfo = rsp.getResults().get(0);

        return convertCommodityDetail(tbInfo);
    }

    @Override
    public List<CommodityDetailDTO> getCommodityDetailList(String goodsIdArray) {


        TaobaoClient client = new DefaultTaobaoClient(commodityInfoProperties.getTbCommodityUrl(),
                commodityInfoProperties.getTbCommodityAppKey(), commodityInfoProperties.getTbCommodityAppSecret());


        TbkItemInfoGetRequest req = new TbkItemInfoGetRequest();
        req.setNumIids(goodsIdArray);

        TbkItemInfoGetResponse rsp;
        try {
            rsp = client.execute(req);
        } catch (ApiException e) {
            log.error("从淘宝接口获取商品详情异常,商品id串为:{},异常为:", goodsIdArray, e);
            return null;
        }

        if (null == rsp || !rsp.isSuccess() || CollectionUtils.isEmpty(rsp.getResults())) {
            log.error("从淘宝接口获取到的商品列表信息为空");
            return null;
        }
        List<TbkItemInfoGetResponse.NTbkItem> tbInfoList = rsp.getResults();

        return tbInfoList.stream().map(this::convertCommodityDetail).collect(Collectors.toList());

    }

    @Override
    public String createTaoWord(String url, String logUrl, String text) {
        TaobaoClient client = new DefaultTaobaoClient(commodityInfoProperties.getTbCommodityUrl(),
                commodityInfoProperties.getTbCommodityAppKey(), commodityInfoProperties.getTbCommodityAppSecret());
        TbkTpwdCreateRequest req = new TbkTpwdCreateRequest();
        req.setText(text);
        req.setUrl(url);
        req.setLogo(logUrl);

        TbkTpwdCreateResponse rsp;
        try {
            rsp = client.execute(req);
        } catch (ApiException e) {
            log.error("创建淘口令异常", e);
            return null;
        }

        if (null == rsp || !rsp.isSuccess() || null == rsp.getData()) {
            log.error("创建淘口令失败, rsp: {}", rsp);
            return null;
        }

        return rsp.getData().getModel();
    }

    @Override
    public TbkJuTqgGetResponse getTqgCommodity(TbkJuTqgGetRequest req) {

        TaobaoClient client = new DefaultTaobaoClient(commodityInfoProperties.getTbCommodityUrl(),
                commodityInfoProperties.getTbCommodityAppKey(), commodityInfoProperties.getTbCommodityAppSecret());


        TbkJuTqgGetResponse rsp;
        try {
            rsp = client.execute(req);
        } catch (ApiException e) {
            log.error("请求淘抢购接口异常", e);
            return null;
        }

        return rsp;
    }

    @Override
    public TbkDgMaterialOptionalResponse getCommodityListByName(TbkDgMaterialOptionalRequest req) {


        TaobaoClient client = new DefaultTaobaoClient(commodityInfoProperties.getTbCommodityUrl(),
                commodityInfoProperties.getTbCommodityAppKey(), commodityInfoProperties.getTbCommodityAppSecret());


        //组装查询参数
        TbkDgMaterialOptionalResponse rsp;

        try {
            rsp = client.execute(req);
        } catch (ApiException e) {
            log.error("从淘宝接口按搜索名获取商品列表异常", e);
            return null;
        }

        return rsp;
    }

    @Override
    public TbkItemRecommendGetResponse getRecommendCommodity(TbkItemRecommendGetRequest req) {


        TaobaoClient client = new DefaultTaobaoClient(commodityInfoProperties.getTbCommodityUrl(),
                commodityInfoProperties.getTbCommodityAppKey(), commodityInfoProperties.getTbCommodityAppSecret());
        TbkItemRecommendGetResponse rsp;
        try {
            rsp = client.execute(req);
        } catch (ApiException e) {
            log.error("从淘宝获取推荐商品异常:", e);
            return null;
        }
        return rsp;
    }

    /**
     * 转换商品详情信息dto
     *
     * @param tbInfo 从淘宝获取到的信息
     * @return 淘宝详情信息dto
     */
    private CommodityDetailDTO convertCommodityDetail(TbkItemInfoGetResponse.NTbkItem tbInfo) {
        CommodityDetailDTO commodityDetailDTO = CommodityDetailDTO.builder()
                .goodsId(tbInfo.getNumIid())
                .reservePrice(Double.valueOf(tbInfo.getZkFinalPrice()))
                .mainPic(tbInfo.getPictUrl())
                .commodityTitle(tbInfo.getTitle())
                .salesNum(null == tbInfo.getVolume() ? null : tbInfo.getVolume().intValue())
                .shopName(tbInfo.getNick())
                .shopType(null == tbInfo.getUserType() ? null : tbInfo.getUserType().intValue())
                .build();

        return commodityDetailDTO;

    }

    @Override
    public TbkActivitylinkGetResponse getTaoBaoUnion(TbkActivitylinkGetRequest req) {

        TaobaoClient client = new DefaultTaobaoClient(commodityInfoProperties.getTbCommodityUrl(), commodityInfoProperties.getTblmCommodityAppKey(), commodityInfoProperties.getTblmCommodityAppSecret());
        TbkActivitylinkGetResponse res;
        try {
            res = client.execute(req);

            if (Objects.isNull(res.getBizErrorCode()) || !Objects.equals(res.getBizErrorCode(), 0L)) {
                log.error("请求淘宝联盟失败，请求数据: {}， 返回数据: {}", JSON.toJSONString(req), JSON.toJSONString(res));
            }

        } catch (ApiException e) {
            log.error("请求淘宝联盟获取跳转链接异常:", e);
            return null;
        }
        return res;
    }


}
