package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.domain.CommodityInfoMapper;
import com.bxm.fossicker.commodity.domain.CommoditySearchLogMapper;
import com.bxm.fossicker.commodity.model.constant.CommodityPoolId;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.service.BlackCommodityService;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @Author: pf.w
 * @Date: 2019/9/17 19:57
 */
@Service
public class BlackCommodityServiceImpl implements BlackCommodityService {

    @Resource
    private CommoditySearchLogMapper commodityMapper;

    @Resource
    private CommodityInfoMapper commodityInfoMapper;

    @Override
    public <T> List rejectCommodity(List<T> list) {
        //3:黑名单商品
        List<String> goodsIdList = commodityMapper.getPoolInfo(3);
        List<T> resultList = new ArrayList<>();
        for (T object : list) {
            if (object instanceof CommoditySearchDTO) {
                String goodsId = ((CommoditySearchDTO) object).getGoodsId().toString();
                if (!goodsIdList.contains(goodsId)) {
                    resultList.add(object);
                }
            }
        }
        return resultList;
    }

    /**
     * 缓存的黑名单商品ID
     */
    private Set<String> blackIds = Sets.newHashSet();

    /**
     * 最后同步时间，用于重新获取黑名单数据
     */
    private long lastSyncMils = 0;

    /**
     * 黑名单数据过期时间
     */
    private final static Long EXPIRED_MILS = 30000L;

    @Override
    public boolean isBlackCommodity(Long goodsId) {
        //商品id为空不做判断
        if (null == goodsId) {
            return false;
        }

        long currentMils = System.currentTimeMillis();

        if (lastSyncMils < currentMils) {
            List<String> swapBlackIds = commodityInfoMapper.getPoolInfo((long) CommodityPoolId.BLACK_LIST);
            lastSyncMils = currentMils + EXPIRED_MILS;

            blackIds = new HashSet<>(swapBlackIds);
        }

        return blackIds.contains(goodsId.toString());
    }
}
