package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.domain.CommodityBrowseFlowMapper;
import com.bxm.fossicker.commodity.facade.BrowseFlowFacadeService;
import com.bxm.fossicker.commodity.model.param.BrowseCommodityParam;
import com.bxm.fossicker.commodity.model.vo.BrowseCountVo;
import com.bxm.fossicker.commodity.model.vo.CommodityBrowseFlow;
import com.bxm.fossicker.commodity.service.BrowseFlowService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 浏览记录服务
 * @ClassName BrowseFlowService
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author XinZhao
 * @Date 2019/7/2 14:27
 * @Version 1.0.0
 **/
@Log4j2
@Service
public class BrowseFlowServiceImpl implements BrowseFlowService, BrowseFlowFacadeService {

    private final CommodityBrowseFlowMapper browseFlowMapper;

    private final SequenceCreater sequenceCreater;

    @Autowired
    public BrowseFlowServiceImpl(CommodityBrowseFlowMapper browseFlowMapper,
                                 SequenceCreater sequenceCreater) {
        this.browseFlowMapper = browseFlowMapper;
        this.sequenceCreater = sequenceCreater;
    }

    @Override
    public Map<Long, Integer> getTotalBrowseMap(List<Long> userIdList) {
        return browseFlowMapper.getTotalCountByList(userIdList).stream()
                .collect(Collectors.toMap(BrowseCountVo::getUserId, BrowseCountVo::getTotalBrowseCount));
    }

    @Override
    public Boolean isBrowseCommodityByToday(Long commodityId, Long userId) {
        CommodityBrowseFlow commodityBrowseFlow = new CommodityBrowseFlow();
        commodityBrowseFlow.setUserId(userId);
        commodityBrowseFlow.setGoodsId(commodityId);

        List<CommodityBrowseFlow> commodityBrowseFlowList = browseFlowMapper.getTodayRecordBySelf(commodityBrowseFlow);

        return !CollectionUtils.isEmpty(commodityBrowseFlowList);
    }

    @Override
    public Boolean addBrowseCommodityRecord(BrowseCommodityParam browseCommodityParam) {
        CommodityBrowseFlow commodityBrowseFlowEntity = new CommodityBrowseFlow();
        commodityBrowseFlowEntity.setId(sequenceCreater.nextLongId());
        commodityBrowseFlowEntity.setUserId(browseCommodityParam.getUserId());
        commodityBrowseFlowEntity.setGoodsId(browseCommodityParam.getGoodsId());
        //浏览类型为自己浏览商品
        commodityBrowseFlowEntity.setBrowseType(1);
        commodityBrowseFlowEntity.setCreateTime(new Date());

        browseFlowMapper.addBrowseRecord(commodityBrowseFlowEntity);
        return true;
    }

    @Override
    public Boolean addBrowseShareCommodityRecord(Long browseUserId, Long shareUserId, Long goodsId) {

        CommodityBrowseFlow commodityBrowseFlowEntity = new CommodityBrowseFlow();
        commodityBrowseFlowEntity.setId(sequenceCreater.nextLongId());
        commodityBrowseFlowEntity.setUserId(browseUserId);
        commodityBrowseFlowEntity.setShareUserId(shareUserId);
        commodityBrowseFlowEntity.setGoodsId(goodsId);
        //浏览类型为浏览分享商品
        commodityBrowseFlowEntity.setBrowseType(2);
        commodityBrowseFlowEntity.setCreateTime(new Date());

        browseFlowMapper.addBrowseRecord(commodityBrowseFlowEntity);
        return true;
    }

    @Override
    public Integer getUserBrowseRecordToday(Long userId) {
        //TODO 商品浏览记录放到缓存
        return browseFlowMapper.getTotalRecordToday(userId);
    }
}
