package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.common.enums.CommodityFavoriteStatusEnum;
import com.bxm.fossicker.commodity.domain.CommodityFavoriteMapper;
import com.bxm.fossicker.commodity.model.param.CollectCommodityParam;
import com.bxm.fossicker.commodity.model.param.UserCollectionCommodityListParam;
import com.bxm.fossicker.commodity.model.vo.CommodityCollectionVO;
import com.bxm.fossicker.commodity.model.vo.CommodityFavorite;
import com.bxm.fossicker.commodity.service.CommodityCollectService;
import com.bxm.fossicker.commodity.service.commodity.list.CommodityListServiceProxy;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
@Slf4j
public class CommodityCollectServiceImpl implements CommodityCollectService {

    /**
     * 商品收藏 mapper
     */
    @Autowired
    private CommodityFavoriteMapper commodityFavoriteMapper;

    /**
     * 序列号创建服务
     */
    @Autowired
    private SequenceCreater sequenceCreater;

    @Autowired
    private CommodityListServiceProxy commodityListServiceProxy;

    @Override
    public Integer getCollectStatus(Long commodityId, Long userId) {
        CommodityFavorite commodityFavoriteEntity = new CommodityFavorite();
        commodityFavoriteEntity.setUserId(userId);
        commodityFavoriteEntity.setTid(commodityId.toString());

        Integer resultCount =
                commodityFavoriteMapper.getCollectStatus(commodityFavoriteEntity);

        //有收藏记录且大于0,则收藏状态为已收藏.否则为未收藏
        return (null != resultCount && resultCount > 0) ? CommodityFavoriteStatusEnum.FAVORITE_STATUS.getStatus()
                : CommodityFavoriteStatusEnum.NOT_FAVORITE_STATUS.getStatus();
    }

    @Override
    public Integer changeCollectStatus(CollectCommodityParam collectCommodityParam) {

        //收藏-新增一条收藏数据
        if (CommodityFavoriteStatusEnum.FAVORITE_STATUS.getStatus().equals(collectCommodityParam.getCollectStatus())) {

            CommodityFavorite insertEntity = new CommodityFavorite();
            insertEntity.setId(sequenceCreater.nextLongId());
            insertEntity.setTid(collectCommodityParam.getGoodsId());
            insertEntity.setUserId(collectCommodityParam.getUserId());
            insertEntity.setDeleteFlag(new Byte("0"));
            insertEntity.setCreateTime(new Date());

            commodityFavoriteMapper.insertSelective(insertEntity);
        } else {
            //取消收藏-设置原先的记录软删除
            CommodityFavorite updateEntity = new CommodityFavorite();
            updateEntity.setTid(collectCommodityParam.getGoodsId());
            updateEntity.setUserId(collectCommodityParam.getUserId());

            commodityFavoriteMapper.notCollectStatus(updateEntity);

        }

        //先查是否有记录
        return 1;
    }

    @Override
    public List<CommodityCollectionVO> gerUserCollection(Long userId) {
        UserCollectionCommodityListParam param = new UserCollectionCommodityListParam();
        param.setUserId(userId);
        param.setQueryLabel(true);

        return commodityListServiceProxy.getCommodityList(param);
    }
}
