package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.common.dto.CommissionAndCoupon;
import com.bxm.fossicker.commodity.facade.CommodityFacadeService;
import com.bxm.fossicker.commodity.facade.dto.CommodityOriginalInfoDTO;
import com.bxm.fossicker.commodity.facade.dto.CommoditySearchFacadeDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.param.GoodsListRequestParam;
import com.bxm.fossicker.commodity.model.vo.CategoryCommodityListItem;
import com.bxm.fossicker.commodity.service.CommodityListService;
import com.bxm.fossicker.commodity.service.CommodityPriceInfoService;
import com.bxm.fossicker.commodity.service.externel.TbCommodityService;
import com.google.common.collect.Lists;
import com.taobao.api.request.TbkActivitylinkGetRequest;
import com.taobao.api.response.TbkActivitylinkGetResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * Created by Gonzo on 2019-07-29.
 */
@Service
@Slf4j
public class CommodityFacadeServiceImpl implements CommodityFacadeService {

    @Autowired
    private TbCommodityService tbCommodityService;

    @Autowired
    private CommodityPriceInfoService commodityPriceInfoService;

    @Autowired
    private CommodityListService commodityListService;

    @Override
    public CommodityOriginalInfoDTO getCommodity(Long goodsId) {
        return convert(tbCommodityService.getCommodityDetail(goodsId));
    }


    /**
     * 转换对象，封装数据
     * @param commodityDetailDTO
     * @return
     */
    private CommodityOriginalInfoDTO convert(CommodityDetailDTO commodityDetailDTO) {
        if (commodityDetailDTO == null) {
            return CommodityOriginalInfoDTO.builder().build();
        }

        CommodityOriginalInfoDTO commodityOriginalInfoDTO = CommodityOriginalInfoDTO.builder()
                .goodsId(commodityDetailDTO.getGoodsId())
                .mainPic(commodityDetailDTO.getMainPic())
                .commodityTitle(commodityDetailDTO.getCommodityTitle())
                .couponPrice(0D)
                .commissionRate(0D)
                .reservePrice(commodityDetailDTO.getReservePrice())
                .build();


        // 价格等信息，在另外一个接口里。
        CommissionAndCoupon commodityCommissionAndCoupon = commodityPriceInfoService.getCommissionAndCouponByThird(commodityOriginalInfoDTO.getGoodsId());


        if (commodityCommissionAndCoupon != null) {
            commodityOriginalInfoDTO.setCommissionRate(commodityCommissionAndCoupon.getCommissionRateByThird());
            commodityOriginalInfoDTO.setCouponPrice(commodityCommissionAndCoupon.getCouponPrice());
        }

        return commodityOriginalInfoDTO;
    }



    @Override
    public List<CommodityOriginalInfoDTO> getCommodityList(String goodsIdArray) {

        List<CommodityDetailDTO> commodityOriginalInfoDTOS = tbCommodityService.getCommodityDetailList(goodsIdArray);
        if (commodityOriginalInfoDTOS == null) {
            return Lists.newArrayList();
        }

        List<CommodityOriginalInfoDTO> infoDTOS = commodityOriginalInfoDTOS.stream()
                .map(this::convert)
                .collect(Collectors.toList());

        return infoDTOS;
    }

    @Override
    public String getImgUrl(Long goodsId) {
        CommodityDetailDTO commodityDetail = tbCommodityService.getCommodityDetail(goodsId);

        if (null == commodityDetail) {
            return null;
        }

        return commodityDetail.getMainPic();
    }

    @Override
    public Long getWellChoseFirstCommodityId(Long userId) {
        // 获取商品池数据
        GoodsListRequestParam param = new GoodsListRequestParam();
        param.setUserId(userId);
        param.setPageOn(1);
        param.setPageSize(1);
        param.setType("WELLCHOSE");

        // 调用第三方接口 大淘客+好单库   方式为：交叉展示
        try {
            List<CategoryCommodityListItem> listOther = commodityListService.goodsListByLabel(param);

            if (!CollectionUtils.isEmpty(listOther)) {
                return listOther.get(0).getGoodsId();
            }
        } catch(Exception e) {
            log.error("查询大淘客、好单库数据失败", e);
        }

        return null;
    }

    @Override
    public TbkActivitylinkGetResponse getTaoBaoUnion(TbkActivitylinkGetRequest req) {
        return tbCommodityService.getTaoBaoUnion(req);
    }

    private CommoditySearchFacadeDTO convert(CommoditySearchDTO commoditySearchDTO) {
        CommoditySearchFacadeDTO result = new CommoditySearchFacadeDTO();
        BeanUtils.copyProperties(commoditySearchDTO, result);

        return result;
    }
}
