package com.bxm.fossicker.commodity.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.common.utils.SignMD5Util;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.NomalGoodsLabelDTO;
import com.bxm.fossicker.commodity.model.dto.SubCategorysForNomalLabelDTO;
import com.bxm.fossicker.commodity.service.CommodityGoodsLabelService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.configurationprocessor.json.JSONArray;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * @Author: pf.w
 * @Date: 2019/9/11 14:51
 */
@Service
@Log4j2
public class CommodityGoodsLabelServiceImpl implements CommodityGoodsLabelService {
    /**
     * redis字符串操作对象
     */
    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    private CommodityInfoProperties commodityInfoProperties;

    @Override
    public NomalGoodsLabelDTO getNomalLabel(String type) {
        NomalGoodsLabelDTO nomalGoodsLabel = new NomalGoodsLabelDTO();
        String result = null;
        KeyGenerator goodsLabel = CommodityRedisKeyConstants.COMMDITY_GOODS_LABEL_CONTANS.copy().appendKey(type);
        result = redisStringAdapter.getString(goodsLabel);
        //从缓存获取
        if (StringUtils.isNotBlank(result)) {
            nomalGoodsLabel = JSONObject.parseObject(result, NomalGoodsLabelDTO.class);
            return nomalGoodsLabel;
        }

        Map<String, Object> paraMap = new TreeMap<>();
        paraMap.put("version", commodityInfoProperties.getDtkCommodityVersion());
        paraMap.put("appKey", commodityInfoProperties.getDtkCommodityAppKey());
        paraMap.put("sign", SignMD5Util.getSignStr(paraMap, commodityInfoProperties.getDtkCommodityAppSecret()));
        try {
            result = OkHttpUtils.get(commodityInfoProperties.getDtkSuperCategoryUrl(), paraMap);
            //首页进入
            if (StringUtils.isNotBlank(result) && "HOMEPAGE".equals(type)) {
                nomalGoodsLabel = JSONObject.parseObject(result, NomalGoodsLabelDTO.class);
                SubCategorysForNomalLabelDTO sfd = new SubCategorysForNomalLabelDTO();
                sfd.setCname("精选");
                sfd.setCid(999999999);
                List<SubCategorysForNomalLabelDTO> list = new ArrayList<>();
                list.add(sfd);
                list.addAll(nomalGoodsLabel.getData());

                nomalGoodsLabel.setData(list);
                //缓存数据信息 失效时间1小时
                redisStringAdapter.set(goodsLabel, JSONObject.toJSONString(nomalGoodsLabel), 60 * 60);
            } else if ("SUPERENTER".equals(type)) { //超级入口进入
                nomalGoodsLabel = JSONObject.parseObject(result, NomalGoodsLabelDTO.class);
                //缓存数据信息 失效时间1小时
                redisStringAdapter.set(goodsLabel, JSONObject.toJSONString(nomalGoodsLabel), 60 * 60);
            } else {
                nomalGoodsLabel = new NomalGoodsLabelDTO();
            }
        } catch (IOException e) {
            log.error("获取分类异常:{}" + e);
        }
        return nomalGoodsLabel;
    }

}
