package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.domain.CommodityInfoMapper;
import com.bxm.fossicker.commodity.facade.CommodityGoodsListQuarzService;
import com.bxm.fossicker.commodity.model.dto.NomalGoodsLabelDTO;
import com.bxm.fossicker.commodity.model.dto.SubCategorysForNomalLabelDTO;
import com.bxm.fossicker.commodity.service.CommodityGoodsLabelService;
import com.bxm.fossicker.commodity.service.CommodityListService;
import com.bxm.fossicker.user.domain.UserInfoMapper;
import com.bxm.fossicker.user.model.entity.UserInfoBean;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * 预加载精选 分类商品列表
 *
 * @Author: pf.w
 * @Date: 2019/9/27 14:38
 */

@Service
@Log4j2
public class CommodityGoodsListQuarzServiceImpl implements CommodityGoodsListQuarzService {

    @Autowired
    private CommodityListService commodityListService;

    @Resource
    private CommodityInfoMapper commodityInfoMapper;

    @Resource
    private UserInfoMapper userInfoMapper;

    @Autowired
    private CommodityGoodsLabelService commodityGoodsLabelService;

    @Override
    public void goodsListPreHeat() {
        try {
            UserInfoBean userInfo = userInfoMapper.selectByPhone("13003110301");
            if(Objects.isNull(userInfo)){
                return;
            }
            List<Long> poolIds = commodityInfoMapper.getAllPool();
            for (Long poolId : poolIds) {
                commodityListService.poolCommodityList(poolId, userInfo.getId(), true);
                commodityListService.poolCommodityList(poolId, userInfo.getId(), false);
            }
        } catch (Exception e) {
            log.error("预热加载商品池列表数据异常"+e);
        }
    }

    private List<String> getNomalLableIds(){
        NomalGoodsLabelDTO nomalGoodsLabelDTO = commodityGoodsLabelService.getNomalLabel("SUPERENTER");
        if(nomalGoodsLabelDTO!=null){
            List<String> nomalLableIds = new ArrayList<>();
            List<SubCategorysForNomalLabelDTO> data = nomalGoodsLabelDTO.getData();
            for (SubCategorysForNomalLabelDTO datum : data) {
                nomalLableIds.add(String.valueOf(datum.getCid()));
            }
            return nomalLableIds;
        }else{
            List<String> nomalLableIds = Arrays.asList("6","4","1","3","9","8","5","7","14","12","11","2","10","13");
            return nomalLableIds;
        }
    }
}
