package com.bxm.fossicker.commodity.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.base.config.ClientConfigProperties;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.constant.CommodityRedisKey;
import com.bxm.fossicker.commodity.model.param.LabelTypeContent;
import com.bxm.fossicker.commodity.model.param.LabelTypeInfo;
import com.bxm.fossicker.commodity.service.strategy.CommodityLabelService;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
@Slf4j
public class CommodityLabelServiceImpl implements CommodityLabelService {

    @Autowired
    private CommodityInfoProperties commodityInfoProperties;

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    private ClientConfigProperties clientConfigProperties;

    @Override
    public List<String> goodsLabel(boolean newbieRight, double handsel, Long goodsId) {
        List<String> labelTypeList = new ArrayList<>();
        if (newbieRight) {
            return new ArrayList<>();
        }
        Date now = new Date();
        //当前时间已经过了最终时间
        if (now.after(strToDate(commodityInfoProperties.getEndTimeForDouble11()))) {
            return new ArrayList<>();
            //当前时间在开始时间之前
        } else if (now.before(strToDate(commodityInfoProperties.getStartTimeForDouble11()))) {
            if (handsel > 0) {
                labelTypeList = getLabelUrl(Arrays.asList(1));
                saveLabelTypeToRedis(goodsId, 1, labelTypeList);
                return labelTypeList;
            } else {
                return new ArrayList<>();
            }
            //双十一当天
        } else if (now.after(strToDate(commodityInfoProperties.getStartTimeForDouble11())) && now.before
                (strToDate(commodityInfoProperties.getEndTimeForDouble11()))) {
            labelTypeList = getLabelUrl(Arrays.asList(2));
            // saveLabelTypeToRedis(goodsId, 2, labelTypeList);
            return labelTypeList;
        } else {
            return new ArrayList<>();
        }
    }

    /**
     * 标签入缓存
     *
     * @param goodsId
     * @param labelType
     */
    private void saveLabelTypeToRedis(Long goodsId, int labelType, List<String> arrays) {
        //有标签信息时入缓存
        if (labelType > 0) {
            LabelTypeInfo labelTypeInfo = new LabelTypeInfo();
            labelTypeInfo.setLabelType(arrays);
            redisHashMapAdapter.put(CommodityRedisKey.GOODS_LABEL_TYPE, goodsId.toString(), JSONObject.toJSONString
                    (labelTypeInfo));
        }
    }

    /**
     * 从缓存获取标签信息(商品详情使用)
     *
     * @param goodsId
     * @return
     */
    @Override
    public List<String> labelTypeFromRedis(Long goodsId) {

        Date now = new Date();
        //当前时间已经过了最终时间
        if (now.after(strToDate(commodityInfoProperties.getEndTimeForDouble11()))) {
            return new ArrayList<>();
            //双十一当天
        } else if (now.after(strToDate(commodityInfoProperties.getStartTimeForDouble11())) && now.before
                (strToDate(commodityInfoProperties.getEndTimeForDouble11()))) {
            return getLabelUrl(Arrays.asList(2));
        } else {
            String redisStr = redisHashMapAdapter.get(CommodityRedisKey.GOODS_LABEL_TYPE, goodsId.toString(),
                    String.class);
            if (Objects.isNull(redisStr)) {
                return new ArrayList<>();
            } else {
                LabelTypeInfo labelTypeInfo = JSONObject.parseObject(redisStr, LabelTypeInfo.class);
                if (Objects.isNull(labelTypeInfo)) {
                    Objects.isNull(labelTypeInfo);
                    return new ArrayList<>();
                } else {
                    return labelTypeInfo.getLabelType();
                }
            }
        }
    }

    private Date strToDate(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date reslut = null;
        try {
            reslut = formatter.parse(strDate);
        } catch (ParseException e) {
            log.error("时间转化 error : {}", e);
        }
        return reslut;
    }

    /**
     * 获取标签对应的标签地址
     *
     * @param labelType
     * @return
     */
    public List<String> getLabelUrl(List<Integer> labelType) {
        String labelTypeContentStr = clientConfigProperties.getCommonKeys().get("labelContent");
        List<String> urlList = new ArrayList<>();
        if (!Objects.isNull(labelTypeContentStr)) {
            List<LabelTypeContent> list = JSON.parseArray(labelTypeContentStr, LabelTypeContent
                    .class);
            if (list.size() > 0) {
                for (Integer label : labelType) {
                    for (LabelTypeContent labelTypeContent : list) {
                        if (labelTypeContent.getLabelType() == label) {
                            urlList.add(labelTypeContent.getUrl());
                            break;
                        }
                    }
                }
            }
        }
        return urlList;
    }
}
