package com.bxm.fossicker.commodity.service.impl;
import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.common.enums.CommodityCidWithPositionEnum;
import com.bxm.fossicker.commodity.model.constant.CommodityPoolId;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.param.*;
import com.bxm.fossicker.commodity.model.vo.BaseCommodityListItem;
import com.bxm.fossicker.commodity.model.vo.CategoryCommodityListItem;
import com.bxm.fossicker.commodity.model.vo.PoolCommodityListItem;
import com.bxm.fossicker.commodity.service.CommodityListService;
import com.bxm.fossicker.commodity.service.commodity.list.CommodityListServiceProxy;
import com.bxm.fossicker.vo.PageWarper;
import com.google.common.collect.Lists;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @Author: pf.w
 * @Date: 2019/7/11 16:44
 */
@Service
@Log4j2
public class CommodityListServiceImpl implements CommodityListService {

    @Autowired
    private CommodityListServiceProxy commodityListServiceProxy;

    @Override
    public List<CategoryCommodityListItem> goodsListByLabel(GoodsListRequestParam param) {

        if (log.isDebugEnabled()) {
            log.debug("商品信息列表 input param :{}", JSON.toJSONString(param));
        }

        switch (param.getType()) {
            // 猜你喜欢(已砍掉不需要做，接口暂时保留)
            case "LIKE":
                return Lists.newArrayList();
            // 精选
            case "WELLCHOSE":
                HomePageWellChoseCommodityListParam homePageWellParam = new HomePageWellChoseCommodityListParam();
                BeanUtils.copyProperties(param, homePageWellParam);
                // 这个接口会被未登录的时候调用
                homePageWellParam.setPublicRequest(true);
                return commodityListServiceProxy.getCommodityList(homePageWellParam);
            // 其他分类
            case "NOMAL":
                CategoryCommodityListParam param1 = new CategoryCommodityListParam();
                BeanUtils.copyProperties(param, param1);
                param1.setCids(param.getCid());
                param1.setQueryGoldInfo(true);
                param1.setQueryLabel(true);
                // 这个接口会被未登录的时候调用
                param1.setPublicRequest(true);
                return commodityListServiceProxy.getCommodityList(param1);
            default:

        }
        return Lists.newArrayList();
    }

    @Override
    public List<CategoryCommodityListItem> goodsListSearchForSubCid(GoodsSearchParam param) {
        CategoryCommodityListParam param1 = new CategoryCommodityListParam();
        BeanUtils.copyProperties(param, param1);

        // 需要查询标签和金币
        param1.setQueryGoldInfo(true);
        param1.setQueryLabel(true);
        return commodityListServiceProxy.getCommodityList(param1);
    }

    @Override
    public List<CategoryCommodityListItem> noviceZeroCommodityList(Long userId) {
        PoolCommodityListParam poolParam = new PoolCommodityListParam();
        poolParam.setPoolId(CommodityPoolId.NOVICE);
        poolParam.setUserId(userId);
        // 查询标签
        poolParam.setQueryLabel(true);
        // 查询金币信息
        poolParam.setQueryGoldInfo(true);
        return commodityListServiceProxy.getCommodityList(poolParam);
    }

    @Override
    public List<PoolCommodityListItem> extendGoodsList(ExtendGoodsListParam param) {
        if (Objects.isNull(param.getPoolId())) {
            return new ArrayList<>();
        }

        // 查询商品池列表
        PoolCommodityListParam poolParam = new PoolCommodityListParam();
        poolParam.setPoolId(param.getPoolId());
        poolParam.setUserId(param.getUserId());
        poolParam.setQueryLabel(true);

        return commodityListServiceProxy.getCommodityList(poolParam);
    }

    @Override
    public List<CategoryCommodityListItem> categoryCommodityList(GoodsListRequestParam param) {
        CategoryCommodityListParam param1 = new CategoryCommodityListParam();
        param1.setUserId(param.getUserId());
        param1.setQueryLabel(true);
        param1.setQueryGoldInfo(true);
        param1.setPageSize(param.getPageSize());
        param1.setPageOn(param.getPageOn());

        // 一级分类
        if (StringUtils.isNotBlank(param.getCid())) {
            param1.setCids(param.getCid());
            return commodityListServiceProxy.getCommodityList(param1);
        }

        return commodityListServiceProxy.getCommodityList(param1);
    }

    @Override
    public List<CategoryCommodityListItem> categoryCommodityListByPosition(GoodsListByPositionParam param) {
        // 根据position决定投放策略
        return categoryCommodityList(assembleParamByPosition(param));
    }

    @Override
    public List<PoolCommodityListItem> poolCommodityList(Long poolId, Long userId,
                                                         boolean isVip) {

        PoolCommodityListParam poolParam = new PoolCommodityListParam();
        poolParam.setPoolId(poolId);
        poolParam.setUserId(userId);
        poolParam.setQueryLabel(true);
        poolParam.setVip(isVip);

        return commodityListServiceProxy.getCommodityList(poolParam);
    }


    @Override
    public List<BaseCommodityListItem> getRecommendCommodity(Long commodityId, Long userId) {

        RecommendCommodityParam param = new RecommendCommodityParam();
        param.setCommodityId(commodityId);
        param.setUserId(userId);
        return commodityListServiceProxy.getCommodityList(param);
    }

    @Override
    public PageWarper<CommoditySearchDTO> getGuessLike(GuessCommodityQueryParam guessCommodityQueryParam) {

        PageWarper<CommoditySearchDTO> resultPage = new PageWarper<>();
        resultPage.setPageNum(guessCommodityQueryParam.getPageNum());
        resultPage.setPageSize(guessCommodityQueryParam.getPageSize());

        // 封装参数
        GuessLikeListParam param = new GuessLikeListParam();
        param.setGuessCommodityQueryParam(guessCommodityQueryParam);
        param.setUserId(guessCommodityQueryParam.getUserId());

        // 请求列表
        resultPage.setList(commodityListServiceProxy.getCommodityList(param));

        return resultPage;
    }

    /**
     * 根据投放区域决定分类策略
     *
     * @param goodsListByPositionParam 请求参数
     * @return 拼装好cid的请求参数
     */
    private GoodsListByPositionParam assembleParamByPosition(GoodsListByPositionParam goodsListByPositionParam) {

        if (CommodityCidWithPositionEnum.FOOD.getPosition().equals(goodsListByPositionParam.getPosition())) {
            goodsListByPositionParam.setCid(CommodityCidWithPositionEnum.FOOD.getCid());
            return goodsListByPositionParam;
        }

        if (CommodityCidWithPositionEnum.HOME_DAILY.getPosition().equals(goodsListByPositionParam.getPosition())) {
            goodsListByPositionParam.setCid(CommodityCidWithPositionEnum.HOME_DAILY.getCid());
            return goodsListByPositionParam;
        }

        //默认给美食分类
        goodsListByPositionParam.setCid(CommodityCidWithPositionEnum.FOOD.getCid());
        return goodsListByPositionParam;

    }

}
