package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.domain.CommodityPoolMapper;
import com.bxm.fossicker.commodity.model.constant.CommodityPoolId;
import com.bxm.fossicker.commodity.model.constant.LowershelfSignEnum;
import com.bxm.fossicker.commodity.model.vo.CommodityPoolStatusVO;
import com.bxm.fossicker.commodity.service.CommodityPoolService;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author: yangxin
 * @date: 2019/12/25  20:37
 */
@Service
@Slf4j
public class CommodityPoolServiceImpl implements CommodityPoolService {

    private final CommodityPoolMapper commodityPoolMapper;

    private final RedisSetAdapter redisSetAdapter;


    @Autowired
    public CommodityPoolServiceImpl(CommodityPoolMapper commodityPoolMapper, RedisSetAdapter redisSetAdapter) {
        this.commodityPoolMapper = commodityPoolMapper;
        this.redisSetAdapter = redisSetAdapter;
    }

    @Override
    public Boolean setNewbieInvalidStatus(Long goodsId) {
        if (null == goodsId) {
            log.warn("新人专享商品，价格变动下架失败，商品id为[{}]", goodsId);
            return false;
        }

        CommodityPoolStatusVO statusVO = new CommodityPoolStatusVO();
        statusVO.setGoodsId(String.valueOf(goodsId));
        statusVO.setPoolsId(CommodityPoolId.NOVICE);
        statusVO.setStatusType((byte) 2);
        statusVO.setLowershelfSign(LowershelfSignEnum.COMMODITY_PRICE_CHANGE.getDes());
        // 清除新人专享redis
        redisSetAdapter.remove(CommodityRedisKeyConstants.COMMODITY_NEWBIE_SET, Objects.toString(goodsId));
        return commodityPoolMapper.updateCommodityStatus(statusVO) > 0;
    }

    @Override
    public void setPoolCommodityInvalidStatus(Long poolId, Long goodsId) {

        if (Objects.nonNull(poolId) && Objects.nonNull(goodsId)) {
            // 如果是新人商品，移除缓存
            if (poolId.equals(CommodityPoolId.NOVICE)) {
                //移除redis
                redisSetAdapter.remove(CommodityRedisKeyConstants.COMMODITY_NEWBIE_SET, Objects.toString(goodsId));
            }

            // 如果是vip 0元购商品 移除缓存
            if (poolId.equals(CommodityPoolId.VIP_ZERO)) {
                //移除redis
                redisSetAdapter.remove(CommodityRedisKeyConstants.COMMODITY_VIP_ZERO_SET, Objects.toString(goodsId));
            }

            // 更新状态
            CommodityPoolStatusVO poolStatusVO = new CommodityPoolStatusVO();
            poolStatusVO.setPoolsId(poolId);
            poolStatusVO.setGoodsId(String.valueOf(goodsId));
            poolStatusVO.setStatusType((byte) 2);
            poolStatusVO.setLowershelfSign(LowershelfSignEnum.COMMODITY_INVALID_LOWERSHELF.getDes());
            commodityPoolMapper.updateCommodityStatus(poolStatusVO);
        }
    }
}
