package com.bxm.fossicker.commodity.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.commodity.common.constants.Constants;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.common.utils.SignMD5Util;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.domain.CommoditySearchLogMapper;
import com.bxm.fossicker.commodity.model.param.HotSearchBeanParam;
import com.bxm.fossicker.commodity.model.param.HotSearchParam;
import com.bxm.fossicker.commodity.model.vo.SearchLog;
import com.bxm.fossicker.commodity.service.CommoditySearchLogService;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * @Author: pf.w
 * @Date: 2019/6/27 17:42
 */
@Service
@Log4j2
public class CommoditySearchLogServiceImpl implements CommoditySearchLogService {

    @Resource
    CommoditySearchLogMapper commoditySearchLogMapper;

    @Autowired
    private CommodityInfoProperties commodityInfoProperties;

    @Override
    public boolean saveSearchLog(SearchLog searchLog) {
        commoditySearchLogMapper.deleteForRepeat(searchLog);
       int saveFlag =  commoditySearchLogMapper.save(searchLog);
        return saveFlag >0 ? true : false;
    }

    @Override
    public boolean deleteSearchLog(Long userId) {
        return commoditySearchLogMapper.updateStatus(userId);
    }

    @Override
    public List<String> getSearchLogByUserId(Long userId) {
        return commoditySearchLogMapper.getSearchLogByUserId(userId);
    }

    @Override
    public List<String> getHotSearchLog() {
        Map<String,Object> paramMap = new TreeMap<>();
        paramMap.put("app_key", commodityInfoProperties.getQtkAppKey());
        paramMap.put("v",commodityInfoProperties.getQtkVersion());
        String resultStr = null;
        try {
            resultStr = OkHttpUtils.get(commodityInfoProperties.getQtkHotSearchUrl(),paramMap);
        } catch (IOException e) {
            log.error("调用热门搜索异常：",e);
        }

        HotSearchParam hotSearchLog = JSONObject.parseObject(resultStr,HotSearchParam.class);
        assert hotSearchLog != null;
        List<HotSearchBeanParam> list = hotSearchLog.getData();
        List<String> listStr = new ArrayList<>();
        for (HotSearchBeanParam hotSearchBeanParam : list) {
            listStr.add(hotSearchBeanParam.getWord());
        }
        return listStr;
    }
}
