package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.CommodityPageInfo;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.param.ClipboardQueryParam;
import com.bxm.fossicker.commodity.model.param.CommoditySearchParam;
import com.bxm.fossicker.commodity.model.vo.SearchLog;
import com.bxm.fossicker.commodity.service.CommoditySearchLogService;
import com.bxm.fossicker.commodity.service.CommoditySearchService;
import com.bxm.fossicker.commodity.service.strategy.CommodityQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 商品搜索相关服务
 * @Author: Gonzo
 * @date  2020-03-02 16:12
 * @since 1.6.0
 */
@Service
@Slf4j
public class CommoditySearchServiceImpl implements CommoditySearchService {

    @Autowired
    private CommodityQueryService commodityQueryByWyImpl;

    @Autowired
    private CommodityQueryService commodityQueryByTbImpl;

    @Autowired
    private CommodityInfoProperties commodityInfoProperties;

    @Autowired
    private CommoditySearchLogService commoditySearchLogService;



    @Override
    public CommodityPageInfo<CommoditySearchDTO> getCommodityListByName(CommoditySearchParam commoditySearchParam) {
        CommodityPageInfo<CommoditySearchDTO> resultPageInfo = new CommodityPageInfo<>();

        //将搜索记录存入搜索表中
        saveSearchLog(commoditySearchParam);

        //工厂方法创建服务-第三方接口对接类型
        CommodityQueryService commodityQueryService = commodityQueryServiceFactory();
        if (null == commodityQueryService) {
            log.error("创建服务失败,请检查实现方式");
            return resultPageInfo;
        }
        resultPageInfo = commodityQueryService.queryCommodityByName(commoditySearchParam);

        return resultPageInfo;
    }

    @Override
    public CommoditySearchDTO getClipboardCommodity(ClipboardQueryParam clipboardQueryParam) {
        log.debug("通过粘贴板信息查询商品信息，请求参数：{}", clipboardQueryParam);
        //工厂方法创建服务-第三方接口对接类型
        CommodityQueryService commodityQueryService = commodityQueryServiceFactory();
        if (null == commodityQueryService) {
            log.error("创建服务失败,请检查实现方式");
            return null;
        }
        CommoditySearchDTO result = commodityQueryService.getClipboardCommodity(clipboardQueryParam);

        log.debug("粘贴板信息采用的服务：{},查询参数：{},商品结果：{}", commodityQueryService.getClass(),
                clipboardQueryParam,
                result);

        return result;
    }

    /**
     * 保存用户浏览记录
     *
     * @param commoditySearchParam 商品查询参数
     */
    private void saveSearchLog(CommoditySearchParam commoditySearchParam) {

        SearchLog searchLog = new SearchLog();
        searchLog.setWords(commoditySearchParam.getCommodityName());
        searchLog.setUserId(commoditySearchParam.getUserId());

        commoditySearchLogService.saveSearchLog(searchLog);
    }

    /**
     * 工厂方法创建
     *
     * @return
     */
    private CommodityQueryService commodityQueryServiceFactory() {
        CommodityQueryService matchService;
        switch (commodityInfoProperties.getSearchSource()) {
            case "weiyi": {
                matchService = commodityQueryByWyImpl;
                break;
            }
            case "taobao":
            default: {
                matchService = commodityQueryByTbImpl;
                break;
            }
        }

        return matchService;
    }
}
