package com.bxm.fossicker.commodity.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.base.facade.service.ShortLinkFacadeService;
import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.config.AdvertTicketProperties;
import com.bxm.fossicker.commodity.domain.CommoditySearchLogMapper;
import com.bxm.fossicker.commodity.facade.TicketFacadeService;
import com.bxm.fossicker.commodity.model.dto.AdvertTicketResultDto;
import com.bxm.fossicker.commodity.model.dto.CommodityInfoDTO;
import com.bxm.fossicker.commodity.model.param.GetCommodityDetailParam;
import com.bxm.fossicker.commodity.model.param.TicketInfo;
import com.bxm.fossicker.commodity.service.commodity.info.CommodityInfoSourceProxyService;
import com.bxm.fossicker.util.PictureMerge;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @Author: pf.w
 * @Date: 2019/10/29 10:02
 */
@Service
@Log4j2
public class TicketFacadeServiceImpl implements TicketFacadeService {

    @Autowired
    private  RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    private CommodityInfoSourceProxyService commodityInfoSourceService;

    @Autowired
    private AdvertTicketProperties advertTicketProperties;

    @Autowired
    private ShortLinkFacadeService shortLinkFacadeService;

    @Autowired
    private AliyunOSSService aliyunOSSService;

    @Resource
    private CommoditySearchLogMapper commoditySearchLogMapper;

    String pathStr = "qtj/gif/ticket/";
    String suffix = ".gif";

    @Override
    public Message adAdvertTicket(Long goodsId) throws Exception {
        // 封装参数
        GetCommodityDetailParam detailParam = new GetCommodityDetailParam();
        // 不查优惠券信息
        detailParam.setQueryCouponInfo(false);
        detailParam.setCommodityId(goodsId);

        CommodityInfoDTO localCommodity = commodityInfoSourceService.getLocalCommodity(detailParam);
        if(Objects.isNull(localCommodity)){
            return Message.build().setSuccess(Boolean.FALSE).setMessage("商品数据异常");
        }
        String linkUrl = shortLinkFacadeService.getGoodsShortLink(goodsId);
        if(Objects.isNull(linkUrl)){
            return Message.build().setSuccess(Boolean.FALSE).setMessage("跳链异常");
        }
        String imgUrl = genImg(String.valueOf(localCommodity.getCouponPrice().intValue()),goodsId.toString());
        if(Objects.isNull(imgUrl)){
            return Message.build().setSuccess(Boolean.FALSE).setMessage("素材图片生成异常");
        }
        log.info("广告卷素材图片地址 imgUrl : {}",imgUrl);

        boolean adTicketOk = addTicket(localCommodity,linkUrl,imgUrl);
         if(!adTicketOk){
             return Message.build().setSuccess(Boolean.FALSE).setMessage("生成广告卷信息异常");
         }
        return Message.build();
    }

    /**
     * 合成图片并上传
     * @return
     */
    private String genImg(String markContent,String goodsId) throws Exception {
        String bgImgURL = advertTicketProperties.getBgImgUrl();
        int size = 90;
        int x = 160;
        int y = 190;
        if(markContent.length()>=4){
            size=70;
        }
        log.info("marContent : "+markContent);
        log.info("bgImgURL : "+bgImgURL);
        byte[] rb =  PictureMerge.getGifSticker(markContent,bgImgURL,size,x,y);
        String imageUrl = aliyunOSSService.upload(rb,pathStr+ goodsId+ suffix);
        return imageUrl;
    }

    //广告卷接口 （一个广告卷对应一个广告卷素材）
    private boolean addTicket(CommodityInfoDTO localCommodity,String url,String imgUrl){
        //生成广告素材
        Map<String,Object> map = new HashMap<>();
        map.put("name",String.valueOf(localCommodity.getCouponPrice().intValue())+"元限量优惠券");
        map.put("vars","0");
        map.put("intro","天猫旗舰店！血亏冲销量～");
        map.put("buttonTxt","立即领取");
        map.put("image",imgUrl);
        map.put("status","1");
        map.put("clickThreshold","100");
        map.put("isPopup","0");
        String httpResult =  queryHttpPostWithToken(advertTicketProperties.getAdAssetUrl(),map,
                advertTicketProperties.getToken
                        ());
        AdvertTicketResultDto result;
        if(!Objects.isNull(httpResult)){
           result = JSON.parseObject(httpResult,AdvertTicketResultDto.class);
        }else{
            return false;
        }
        log.info("素材ID : {}",result.getReturnValue());

        //生成广告卷
        Map<String,Object> mapTicket = new HashMap<>();
        mapTicket.put("assetsids",result.getReturnValue());
        mapTicket.put("url",url);
        //广告名称
        mapTicket.put("name","QTJ"+localCommodity.getGoodsId());
        //临时为：2423, 上线时需要确认
        mapTicket.put("advertiser",advertTicketProperties.getAdvertiser());
        //结算方式：1- CPC、2- CPA、4- CPM
        mapTicket.put("settleType",1);
        //广告券类型。1- 常规券、2- 备用券、3- 激励券、4- 券码类、5- ADX直投、6- ADX互动、7- 激励视频
        mapTicket.put("type",1);
        mapTicket.put("price",localCommodity.getPlatformCommissionPrice()*0.4);
        //日预算
        mapTicket.put("budgetDaily",10000);
        mapTicket.put("validStartDate","2019-10-24");
        mapTicket.put("validEndDate","2099-12-30");
        mapTicket.put("tags",advertTicketProperties.getTags());
        mapTicket.put("domainCode",advertTicketProperties.getDomainCode());
        mapTicket.put("booleanCitys",false);
        mapTicket.put("apps","5,1,2");
        mapTicket.put("oss","1,2,4");
        mapTicket.put("standaloneCost",0);
        mapTicket.put("weight",100);
        mapTicket.put("controlDto.booleanTimes",false);
        mapTicket.put("controlDto.noimei",0);
        mapTicket.put("controlDto.imeinomatching",0);
        mapTicket.put("ocpcConf.isSupportOcpc",1);
        mapTicket.put("ocpcConf.cpaExpectPrice",4);
        mapTicket.put("ocpcConf.closeThreshold",280);
        mapTicket.put("flowPackageArray","[]");
        mapTicket.put("flowPackageArrayConfs","[]");
        mapTicket.put("isGroup",false);
        mapTicket.put("isEffectMonitor",1);
        mapTicket.put("ae",advertTicketProperties.getAe());
        mapTicket.put("status",3);
        String httpResultTicket =  queryHttpPostWithToken(advertTicketProperties.getAdTicketUrl(),mapTicket,
                advertTicketProperties.getToken
                        ());
        AdvertTicketResultDto resultTicket = null;
        if(!Objects.isNull(httpResultTicket)){
            resultTicket = JSON.parseObject(httpResultTicket,AdvertTicketResultDto.class);
        }else{
            return false;
        }
        log.info("广告卷ID : {}",resultTicket.getReturnValue());

        //广告卷信息存入缓存
        TicketInfo info = new TicketInfo();
        info.setAssetId(result.getReturnValue());
        info.setTicketId(resultTicket.getReturnValue());
        info.setCouponPrice(localCommodity.getCouponPrice());
        info.setPlatformCommissionPrice(localCommodity.getPlatformCommissionPrice());
        info.setUrl(imgUrl);
        redisHashMapAdapter.put(CommodityRedisKeyConstants.COMMODITY_TICKET_GOODS_INFO,localCommodity.getGoodsId().toString(),
                JSONObject.toJSONString(info));
        return Boolean.TRUE;
    }


    @Override
    public boolean updateAdvertTicket(Long goodsId) throws Exception {
        // 封装参数
        GetCommodityDetailParam detailParam = new GetCommodityDetailParam();
        // 不查优惠券信息
        detailParam.setQueryCouponInfo(false);
        detailParam.setCommodityId(goodsId);

        CommodityInfoDTO localCommodity = commodityInfoSourceService.getLocalCommodity(detailParam);
        if(Objects.isNull(localCommodity)){
            return false;
        }
        String redisStr = redisHashMapAdapter.get(CommodityRedisKeyConstants.COMMODITY_TICKET_GOODS_INFO,localCommodity
                .getGoodsId()
                .toString(),String.class);
        TicketInfo info = null;
        if(!Objects.isNull(redisStr)){
            info = JSONObject.parseObject(redisStr,TicketInfo.class);
        }
        if(Objects.isNull(info)){
            return false;
        }
        //商品下架 直接下掉广告卷
        if(localCommodity.getStatus()==0){
            deleteAdvertTicket(goodsId);
            return true;
        }
        //判断优惠券价格和佣金价格是否变更，都不变更则不更新
        if(localCommodity.getCouponPrice().equals(info.getCouponPrice()) && localCommodity.getPlatformCommissionPrice()
                .equals(info.getPlatformCommissionPrice())){
            return false;
        }
        String imgUrl = genImg(String.valueOf(localCommodity.getCouponPrice().intValue()),goodsId.toString());
        //生成广告素材
        Map<String,Object> map = new HashMap<>();
        map.put("id",info.getAssetId());
        map.put("name",String.valueOf(localCommodity.getCouponPrice().intValue())+"元限量优惠券");
        map.put("vars","0");
        map.put("intro","天猫旗舰店！血亏冲销量～");
        map.put("buttonTxt","立即领取");
        map.put("image",imgUrl);
        map.put("status","1");
        map.put("clickThreshold","100");
        map.put("isPopup","0");
        String httpResult =  queryHttpPostWithToken(advertTicketProperties.getUpdateAssetUrl(),map,
                advertTicketProperties.getToken
                        ());
        AdvertTicketResultDto result = null;
        if(!Objects.isNull(httpResult)){
           result =  JSON.parseObject(httpResult,AdvertTicketResultDto.class);
        }
        if(!Objects.isNull(result)){
            info.setUrl(imgUrl);
            redisHashMapAdapter.put(CommodityRedisKeyConstants.COMMODITY_TICKET_GOODS_INFO,localCommodity.getGoodsId().toString(),
                    JSONObject.toJSONString(info));

        }
        return true;
    }

    @Override
    public int deleteAdvertTicket(Long goodsId) {
        String ticketInfoStr = redisHashMapAdapter.get(CommodityRedisKeyConstants.COMMODITY_TICKET_GOODS_INFO,
                goodsId.toString(),String.class);
        if(StringUtils.isNotBlank(ticketInfoStr)){
            TicketInfo info = JSONObject.parseObject(ticketInfoStr,TicketInfo.class);
            Map<String,Object> map = new HashMap<>();
            map.put("id",info.getTicketId());
            //状态:2 暂停、3 停止、99 已删除
            map.put("status",2);
            queryHttpPostWithToken(advertTicketProperties.getUpStatusTicketUrl(),map,
                    advertTicketProperties.getToken());
        }
        return 1;
    }

    @Override
    public int updateAdvertTicket() {
        List<String> goodsIds = commoditySearchLogMapper.getPoolInfo(5);
        int updateNum = 0;
        int needUpdateNum = 0;
        for (String goodsId : goodsIds) {
            try {
                if (needToUpdate(Long.valueOf(goodsId))) {
                    needUpdateNum++;
                    updateAdvertTicket(Long.valueOf(goodsId));
                    updateNum++;
                }
            } catch (Exception e) {
                log.error("修改广告卷内容出问题了：goodsId:{}", goodsId);
                e.printStackTrace();
            }
        }
        log.info("更新优惠卷价格和佣金值不一样的卷，池内卷共{}条，有{}条需要更新，成功更新{}条", goodsIds.size(), needUpdateNum, updateNum);
        return updateNum;
    }

    /**
     * 检查卷是否需要更新
     * @param goodsId 商品id
     * @return true需要更新 false不需要更新
     */
    private boolean needToUpdate(Long goodsId) {
        // 封装参数
        GetCommodityDetailParam detailParam = new GetCommodityDetailParam();
        // 不查优惠券信息
        detailParam.setQueryCouponInfo(false);
        detailParam.setCommodityId(goodsId);

        CommodityInfoDTO localCommodity = commodityInfoSourceService.getLocalCommodity(detailParam);
        if(Objects.isNull(localCommodity)){
            return false;
        }
        String redisStr = redisHashMapAdapter.get(CommodityRedisKeyConstants.COMMODITY_TICKET_GOODS_INFO,localCommodity
                .getGoodsId()
                .toString(),String.class);
        TicketInfo info = null;
        if(!Objects.isNull(redisStr)){
            info = JSONObject.parseObject(redisStr,TicketInfo.class);
        }
        if(Objects.isNull(info)){
            return false;
        }
        //商品下架也要更新
        if(localCommodity.getStatus()==0){
            return true;
        }
        //判断优惠券价格和佣金价格是否变更，都不变更则不更新
        if(localCommodity.getCouponPrice().equals(info.getCouponPrice()) && localCommodity.getPlatformCommissionPrice()
                .equals(info.getPlatformCommissionPrice())){
            return false;
        }
        return true;
    }


    private String queryHttpPostWithToken(String queryUrl, Map<String, Object> queryParamMap,String token) {

        String resultStr = null;
        for (int tryTimes = 1; tryTimes < 3; tryTimes++) {
            try {
                resultStr = OkHttpUtils.postFormWithToken(queryUrl, queryParamMap,token);
            } catch (IOException e) {
                log.error("根据参数请求http接口异常,请求参数:{},异常:{}", JSON.toJSONString(queryParamMap), e);
            }

            if (org.apache.commons.lang3.StringUtils.isNotBlank(resultStr)) {
                return resultStr;
            }
        }
        return resultStr;

    }
}
