package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.facade.WellChooseRemoveCache;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Author: pf.w
 * @Date: 2019/12/9 10:55
 */
@Service
public class WellChooseRemoveCacheImpl implements WellChooseRemoveCache {

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Override
    public void removeChace(Long userId) {
        KeyGenerator redisKey = CommodityRedisKeyConstants.COMMODITY_GOODS_LIST_WELLCHOSE_POOL_KEY;
        KeyGenerator redisKey2 = CommodityRedisKeyConstants.COMMODITY_GOODS_LIST_WELLCHOSE_POOL_TOP_KEY;

        redisStringAdapter.remove(redisKey.copy().appendKey(userId));
        redisStringAdapter.remove(redisKey2.copy().appendKey(userId));
    }
}
