package com.bxm.fossicker.commodity.service.strategy;

import java.util.List;

public interface CommodityLabelService {

    /**
     * 商品列表标签  双十一标签字段 0:不显示标签  1：双十一预售标签   2：双十一标签  特殊说明：新人专享标签优先级最高
     *
     * @param newbieRight 新人专享优先级最高
     * @param handsel     商品预定金 >0添加预售标签
     * @param goodsId 商品id
     * @return
     */
    List<String> goodsLabel(boolean newbieRight, double handsel, Long goodsId);

    /**
     * 从缓存获取标签信息(商品详情使用)
     *
     * @param goodsId 商品id
     * @return
     */
    List<String> labelTypeFromRedis(Long goodsId);

}
