package com.bxm.fossicker.commodity.service.strategy;

import com.bxm.fossicker.commodity.model.dto.CommodityPageInfo;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.model.param.ClipboardQueryParam;
import com.bxm.fossicker.commodity.model.param.CommoditySearchParam;

public interface CommodityQueryService {

    /**
     * 根据搜索名查询商品列表
     * @param commoditySearchParam 查询参数
     * @return 查询到的商品列表
     */
    CommodityPageInfo<CommoditySearchDTO> queryCommodityByName(CommoditySearchParam commoditySearchParam);

    /**
     * 获取粘贴板信息
     * @param clipboardQueryParam 查询参数
     * @return 商品信息
     */
    CommoditySearchDTO getClipboardCommodity(ClipboardQueryParam clipboardQueryParam);
}
