package com.bxm.fossicker.commodity.service.strategy;

import com.bxm.fossicker.commodity.common.dto.CommissionAndCoupon;

public interface PriceByThirdStrategyService {

    /**
     * 获取优惠券和佣金信息
     * @param goodsId 商品id
     * @return 优惠券和佣金信息
     */
    CommissionAndCoupon getCommissionAndCoupon(Long goodsId);


    /**
     * 获取商品原价
     * @param goodsId 商品id
     * @return 商品原价
     */
    Double getPriceInfo(Long goodsId);
}
