package com.bxm.fossicker.commodity.service.strategy;

import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.dto.CommissionAndCoupon;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.bxm.fossicker.commodity.model.dto.HdkCommissionDataDTO;
import com.bxm.fossicker.commodity.service.externel.HdkCommodityService;
import com.bxm.fossicker.commodity.service.externel.TbCommodityService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;


@Slf4j
@Service("priceStrategyByHdkService")
public class PriceStrategyByHdkServiceImpl implements PriceByThirdStrategyService {

    @Autowired
    private HdkCommodityService hdkCommodityService;

    @Autowired
    private TbCommodityService tbCommodityService;

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    private CommodityInfoProperties commodityInfoProperties;

    @Override
    public CommissionAndCoupon getCommissionAndCoupon(Long goodsId) {

        if (null == goodsId) {
            log.error("查询佣金和优惠券服务,商品id不能为空");
            return null;
        }
        //先从redis中取
        KeyGenerator commissionKey = CommodityRedisKeyConstants.COMMODITY_COMMISSION.copy().setKey(goodsId.toString());

        CommissionAndCoupon commissionInfoByRedis = redisStringAdapter.get(commissionKey, CommissionAndCoupon.class);
        if (null != commissionInfoByRedis) {
            return commissionInfoByRedis;
        }


        HdkCommissionDataDTO hdkCommissionDataDTO = hdkCommodityService.getCommissionAndCoupon(goodsId,commodityInfoProperties.getHdkCommodityPid());
        if (null == hdkCommissionDataDTO) {
            return null;
        }

        CommissionAndCoupon commissionInfoDTO = CommissionAndCoupon.builder()
                //好单库的佣金比率为20这样的比率形式,需转换成小数形式
                .commissionRateByThird(new BigDecimal(hdkCommissionDataDTO.getMax_commission_rate()).divide(new BigDecimal("100")).doubleValue())
                .couponPrice(Double.valueOf(hdkCommissionDataDTO.getCouponmoney()))
                .couponUrl(hdkCommissionDataDTO.getCoupon_click_url())
                .build();

        redisStringAdapter.set(commissionKey, commissionInfoDTO, 3600L);



        return commissionInfoDTO;
    }

    @Override
    public Double getPriceInfo(Long goodsId) {

        if (null == goodsId) {
            log.warn("获取商品价格,商品id不能为空");
            return null;
        }

        //从redis中取,要是能取到直接返回
        KeyGenerator priceInfoKey = CommodityRedisKeyConstants.COMMODITY_PRICE.copy().setKey(goodsId.toString());
        String priceInfoByRedis = redisStringAdapter.getString(priceInfoKey);
        if (StringUtils.isNotBlank(priceInfoByRedis)) {
            return Double.valueOf(priceInfoByRedis);
        }

        //先去好单库数据,若取不到,再取淘宝客数据
        Double reservePrice = hdkCommodityService.getPriceInfo(goodsId);

        if (null != reservePrice) {
            redisStringAdapter.set(priceInfoKey, reservePrice.toString(), 3600L);
            return reservePrice;
        }

        //取淘宝客数据
        CommodityDetailDTO commodityDetailDTO = tbCommodityService.getCommodityDetail(goodsId);
        if (null == commodityDetailDTO) {
            log.warn("获取商品价格信息无法从第三方获取,商品id为:{}", goodsId);
            return null;
        }
        Double reservePriceFromTb = commodityDetailDTO.getReservePrice();
        if (null != reservePriceFromTb) {
            redisStringAdapter.set(priceInfoKey, reservePriceFromTb.toString(), 3600L);
        }
        return reservePriceFromTb;
    }
}

