package com.bxm.fossicker.commodity.service.strategy;

import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.dto.CommissionAndCoupon;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.bxm.fossicker.commodity.service.externel.TbCommodityService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("priceStrategyByTbService")
@Slf4j
public class PriceStrategyByTbServiceImpl implements PriceByThirdStrategyService {

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    private TbCommodityService tbCommodityService;

    @Override
    public CommissionAndCoupon getCommissionAndCoupon(Long goodsId) {
        return null;
    }

    @Override
    public Double getPriceInfo(Long goodsId) {
        if (null == goodsId) {
            log.warn("获取商品价格,商品id不能为空");
            return null;
        }

        //从redis中取,要是能取到直接返回
        KeyGenerator priceInfoKey = CommodityRedisKeyConstants.COMMODITY_PRICE.copy().setKey(goodsId.toString());
        String priceInfoByRedis = redisStringAdapter.getString(priceInfoKey);
        if (StringUtils.isNotBlank(priceInfoByRedis)) {
            return Double.valueOf(priceInfoByRedis);
        }


        //取淘宝客数据
        CommodityDetailDTO commodityDetailDTO = tbCommodityService.getCommodityDetail(goodsId);
        if (null == commodityDetailDTO) {
            log.warn("获取商品价格信息无法从第三方获取,商品id为:{}", goodsId);
            return null;
        }
        Double reservePriceFromTb = commodityDetailDTO.getReservePrice();
        if (null != reservePriceFromTb) {
            redisStringAdapter.set(priceInfoKey, reservePriceFromTb.toString(), 3600L);
        }
        return reservePriceFromTb;

    }
}
