package com.bxm.fossicker.commodity.service.strategy;

import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.common.dto.CommissionAndCoupon;
import com.bxm.fossicker.commodity.common.utils.CommodityCalUtils;
import com.bxm.fossicker.commodity.model.dto.WyCommissionDataDTO;
import com.bxm.fossicker.commodity.service.externel.WyCommodityService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Objects;


@Service("commissionStrategyByWyService")
@Slf4j
public class PriceStrategyByWyServiceImpl implements PriceByThirdStrategyService {

    @Autowired
    private WyCommodityService wyCommodityService;

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Override
    public CommissionAndCoupon getCommissionAndCoupon(Long goodsId) {

        // 先从redis中取
        KeyGenerator commissionKey = CommodityRedisKeyConstants.COMMODITY_COMMISSION.copy().setKey(goodsId.toString());

        CommissionAndCoupon commissionInfoByRedis = redisStringAdapter.get(commissionKey, CommissionAndCoupon.class);
        if (null != commissionInfoByRedis) {
            return commissionInfoByRedis;
        }


        WyCommissionDataDTO commissionInfo = wyCommodityService.getCommissionInfo(goodsId);
        if (Objects.isNull(commissionInfo)) {
            return null;
        }

        CommissionAndCoupon commissionInfoDTO =  convert(commissionInfo);
        redisStringAdapter.set(commissionKey, commissionInfoDTO, 3600L);

        return commissionInfoDTO;
    }

    @Override
    public Double getPriceInfo(Long goodsId) {
        return null;
    }

    /**
     * 参数转换
     * @param commissionInfo 维易三方高佣数据接口
     * @return 平台商品佣金信息
     */
    private CommissionAndCoupon convert(WyCommissionDataDTO commissionInfo) {

        Long goodsId = StringUtils.isNotBlank(commissionInfo.getGoodsId()) ? Long.parseLong(commissionInfo.getGoodsId()) : null;
        Double commissionRate = null;
        if (StringUtils.isNotBlank(commissionInfo.getCommissionRate())) {
            commissionRate = new BigDecimal(commissionInfo.getCommissionRate())
                    .divide(new BigDecimal("100")).doubleValue();
        }


        return CommissionAndCoupon.builder()
                .goodsId(goodsId)
                .couponPrice(CommodityCalUtils.getCouponPriceByRegex(commissionInfo.getCouponInfo()))
                .commissionRateByThird(commissionRate)
                .couponUrl(commissionInfo.getCouponUrl())
                .build();


    }

}
