package com.bxm.fossicker.commodity.timer;

import com.bxm.fossicker.commodity.facade.CommodityGoodsListQuarzService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @Author: pf.w
 * @Date: 2019/12/27 15:50
 */
@Component
@Log4j2
public class PreHeatPoolGoodsTask extends AbstractCronTask<String> {

    @Autowired
    private CommodityGoodsListQuarzService service;
    @Override
    protected ReturnT<String> service(String s) {
        log.info("---预热商品池数据开始 : {}", LocalDateTime.now());
        try {
            service.goodsListPreHeat();
        } catch (Exception e) {
            log.error("预热商品池数据,异常为:", e);
            return ReturnT.FAIL;
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "预热商品池数据";
    }

    @Override
    public String cron() {
        //"每隔5分钟更新一次"
        return "0 0/5 * * * ?";
    }
}
