package com.bxm.fossicker.commodity.timer;

import com.bxm.fossicker.commodity.facade.TicketFacadeService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @Author: pf.w
 * @Date: 2019/12/4 16:35
 */
@Component
@Log4j2
public class UpdateTicketTask extends AbstractCronTask<String> {
    @Autowired
    private TicketFacadeService ticketFacadeService;
    @Override
    protected ReturnT<String> service(String s) {
        log.info("----更新优惠卷价格和佣金值不一样的卷内容开始 : {}", LocalDateTime.now());
        try {
            ticketFacadeService.updateAdvertTicket();
        } catch (Exception e) {
            log.error("更新优惠卷价格和佣金值不一样的卷内容,异常为:", e);
        }
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "更新本地的和redis中的优惠卷价格和佣金值不一样的卷内容";
    }

    @Override
    public String cron() {
        //"每隔5分钟更新一次"
        return "0 0/5 * * * ?";
    }
}
