/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.facade;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.domain.CommodityPoolMapper;
import com.bxm.fossicker.commodity.model.param.CommodityQuartStatusParam;
import com.bxm.fossicker.commodity.model.vo.CommodityPoolStatusVO;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommodityQuartUpperShelfTask
extends AbstractTaskCallback<CommodityQuartStatusParam> {
    private static final Logger log = LogManager.getLogger(CommodityQuartUpperShelfTask.class);
    @Autowired
    private CommodityPoolMapper poolMapper;
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private RedisStringAdapter redisStringAdapter;

    protected ReturnT<String> service(CommodityQuartStatusParam quartStatus) {
        log.info("\u5546\u54c1\u6c60\u5546\u54c1\u4e0a\u67b6, \u8bf7\u6c42\u53c2\u6570:[{}]", (Object)JSONObject.toJSONString((Object)quartStatus));
        try {
            CommodityPoolStatusVO poolStatusVO = new CommodityPoolStatusVO();
            poolStatusVO.setGoodsId(quartStatus.getGoodsId());
            poolStatusVO.setPoolsId(quartStatus.getPoolsId());
            poolStatusVO.setStatusType(Byte.valueOf((byte)1));
            this.poolMapper.updateCommodityStatus(poolStatusVO);
            this.redisStringAdapter.remove(this.getKeyGenerator(quartStatus.getPoolsId(), "isVip"));
            this.redisStringAdapter.remove(this.getKeyGenerator(quartStatus.getPoolsId(), "noVip"));
            if (Objects.equals(1L, quartStatus.getPoolsId())) {
                this.redisSetAdapter.add(CommodityRedisKeyConstants.COMMODITY_NEWBIE_SET, new Object[]{Objects.toString(quartStatus.getGoodsId())});
            }
            if (Objects.equals(23L, quartStatus.getPoolsId())) {
                this.redisSetAdapter.add(CommodityRedisKeyConstants.COMMODITY_VIP_ZERO_SET, new Object[]{Objects.toString(quartStatus.getGoodsId())});
            }
            return ReturnT.SUCCESS;
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u6c60\u5546\u54c1\u4e0a\u67b6\u51fa\u73b0\u9519\u8bef, \u8bf7\u6c42\u53c2\u6570:[{}]", (Object)JSONObject.toJSONString((Object)quartStatus), (Object)e);
            return ReturnT.FAIL;
        }
    }

    private KeyGenerator getKeyGenerator(Long poolId, String vipOrNot) {
        return CommodityRedisKeyConstants.COMMODITY_GOODS_LIST_EXTEND.copy().appendKey((Object)poolId).appendKey((Object)vipOrNot);
    }
}

