/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.commodity.info.source;

import com.bxm.fossicker.commodity.common.enums.ShopTypeEnum;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailInfoDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityInfoDTO;
import com.bxm.fossicker.commodity.model.param.GetCommodityDetailParam;
import com.bxm.fossicker.commodity.service.BlackCommodityService;
import com.bxm.fossicker.commodity.service.commodity.info.CommodityInfoSourceStrategy;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractCommodityInfoSourceStrategy
implements CommodityInfoSourceStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractCommodityInfoSourceStrategy.class);
    @Autowired
    protected BlackCommodityService blackCommodityService;
    @Autowired
    protected RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    protected RedisStringAdapter redisStringAdapter;

    @Override
    public CommodityInfoDTO getCommodityDetail(GetCommodityDetailParam param) {
        if (Objects.isNull(param) || Objects.isNull(param.getCommodityId())) {
            log.error("\u5546\u54c1id\u4e3anull\uff0c\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25");
            return null;
        }
        CommodityInfoDTO infoDTO = this.doGetCommodityDetail(param);
        this.setImgUrlListFromFirstPicIfNecessary(infoDTO);
        return infoDTO;
    }

    @Override
    public List<CommodityDetailInfoDTO> getCommodityDetailInfo(Long commodityId) {
        if (Objects.isNull(commodityId)) {
            log.error("\u5546\u54c1id\u4e3anull\uff0c\u83b7\u53d6\u56fe\u6587\u4fe1\u606f\u5931\u8d25");
            return Lists.newArrayList();
        }
        return this.doGetCommodityDetailInfo(commodityId);
    }

    protected Integer getShopTypeFromTypeCode(String type) {
        if (StringUtils.isBlank((String)type)) {
            return ShopTypeEnum.DEFAULT.getType();
        }
        if (type.contains(ShopTypeEnum.TAOBAO.getDescription())) {
            return ShopTypeEnum.TAOBAO.getType();
        }
        if (type.contains(ShopTypeEnum.TMALL.getDescription())) {
            return ShopTypeEnum.TMALL.getType();
        }
        return ShopTypeEnum.DEFAULT.getType();
    }

    protected void setImgUrlListFromFirstPicIfNecessary(CommodityInfoDTO infoDTO) {
        if (Objects.isNull(infoDTO)) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)infoDTO.getImgUrlList()) && StringUtils.isNotBlank((String)infoDTO.getMainPic())) {
            infoDTO.setImgUrlList(Collections.singletonList(infoDTO.getMainPic()));
        }
    }

    protected abstract CommodityInfoDTO doGetCommodityDetail(GetCommodityDetailParam var1);

    protected abstract List<CommodityDetailInfoDTO> doGetCommodityDetailInfo(Long var1);
}

