/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.commodity.info.source;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.common.enums.LocalCommodityStatusEnum;
import com.bxm.fossicker.commodity.model.constant.CommoditySourceEnum;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailInfoDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityInfoDTO;
import com.bxm.fossicker.commodity.model.param.GetCommodityDetailParam;
import com.bxm.fossicker.commodity.service.commodity.info.CommodityInfoSourceProxyService;
import com.bxm.fossicker.commodity.service.commodity.info.CommodityInfoSourceStrategy;
import com.bxm.fossicker.commodity.service.commodity.info.source.annotation.CommoditySourceStage;
import com.google.common.collect.Maps;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CommodityInfoSourceProxyServiceImpl
implements CommodityInfoSourceProxyService {
    private static final Logger log = LoggerFactory.getLogger(CommodityInfoSourceProxyServiceImpl.class);
    private static final Map<CommoditySourceEnum, CommodityInfoSourceStrategy> STAGE_MAP = Maps.newHashMap();

    @Override
    public CommodityInfoDTO getCommodityDetail(Long commodityId) {
        return this.getCommodityDetail(GetCommodityDetailParam.builder().commodityId(commodityId).queryCouponInfo(true).build());
    }

    @Override
    public CommodityInfoDTO getCommodityDetail(GetCommodityDetailParam param) {
        Long commodityId;
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u5546\u54c1\u4fe1\u606f\uff0c\u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString((Object)param));
        }
        if (Objects.isNull(commodityId = param.getCommodityId())) {
            log.warn("commodityId \u4e3a\u7a7a");
            return null;
        }
        CommodityInfoSourceStrategy stage = STAGE_MAP.get(CommoditySourceEnum.LOCAL);
        if (Objects.isNull(stage)) {
            log.warn("\u6570\u636e\u6e90\u7c7b\u578b: {} \u7684\u5904\u7406\u7c7b\u4e3anull", (Object)CommoditySourceEnum.LOCAL);
            return null;
        }
        CommodityInfoDTO commodityInfoDTO = stage.getCommodityDetail(param);
        if (!param.isIfLocalDownThenReturnNull() && (Objects.isNull(commodityInfoDTO) || Objects.equals(LocalCommodityStatusEnum.InValid.getStatus(), commodityInfoDTO.getStatus()))) {
            stage = STAGE_MAP.get(CommoditySourceEnum.TAOBAO);
            if (Objects.isNull(stage)) {
                log.warn("\u6570\u636e\u6e90\u7c7b\u578b: {} \u7684\u5904\u7406\u7c7b\u4e3anull", (Object)CommoditySourceEnum.TAOBAO);
                return null;
            }
            commodityInfoDTO = stage.getCommodityDetail(param);
        }
        return commodityInfoDTO;
    }

    @Override
    public List<CommodityDetailInfoDTO> getCommodityDetailInfo(Long commodityId) {
        CommodityInfoSourceStrategy stage = STAGE_MAP.get(CommoditySourceEnum.LOCAL);
        if (Objects.isNull(stage)) {
            log.warn("\u6570\u636e\u6e90\u7c7b\u578b: {} \u7684\u5904\u7406\u7c7b\u4e3anull", (Object)CommoditySourceEnum.LOCAL);
            return null;
        }
        List<CommodityDetailInfoDTO> detailInfo = stage.getCommodityDetailInfo(commodityId);
        if (!CollectionUtils.isEmpty(detailInfo)) {
            return detailInfo;
        }
        stage = STAGE_MAP.get(CommoditySourceEnum.TAOBAO);
        if (Objects.isNull(stage)) {
            log.warn("\u6570\u636e\u6e90\u7c7b\u578b: {} \u7684\u5904\u7406\u7c7b\u4e3anull", (Object)CommoditySourceEnum.TAOBAO);
            return null;
        }
        return stage.getCommodityDetailInfo(commodityId);
    }

    @Override
    public CommodityInfoDTO getLocalCommodity(Long commodityId) {
        return this.getLocalCommodity(GetCommodityDetailParam.builder().commodityId(commodityId).queryCouponInfo(true).build());
    }

    @Override
    public CommodityInfoDTO getLocalCommodity(GetCommodityDetailParam param) {
        CommodityInfoSourceStrategy stage = STAGE_MAP.get(CommoditySourceEnum.LOCAL);
        if (Objects.isNull(stage)) {
            log.warn("\u6570\u636e\u6e90\u7c7b\u578b: {} \u7684\u5904\u7406\u7c7b\u4e3anull", (Object)CommoditySourceEnum.LOCAL);
            return null;
        }
        return stage.getCommodityDetail(param);
    }

    @Override
    public CommodityInfoDTO getThirdpartyCommodity(GetCommodityDetailParam param) {
        CommodityInfoSourceStrategy stage = STAGE_MAP.get(CommoditySourceEnum.TAOBAO);
        if (Objects.isNull(stage)) {
            log.warn("\u6570\u636e\u6e90\u7c7b\u578b: {} \u7684\u5904\u7406\u7c7b\u4e3anull", (Object)CommoditySourceEnum.TAOBAO);
            return null;
        }
        return stage.getCommodityDetail(param);
    }

    @Override
    @Async
    public void preheatCommodityInfo(List<Long> commodityIds) {
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u54c1\u4fe1\u606f\u6570\u636e\u9884\u70ed\uff0c\u5f00\u59cb");
        }
        commodityIds.parallelStream().forEach(p -> this.getCommodityDetail(GetCommodityDetailParam.builder().commodityId(p).build()));
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u54c1\u4fe1\u606f\u6570\u636e\u9884\u70ed\uff0c\u7ed3\u675f");
        }
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void onApplicationStartedEvent(ContextRefreshedEvent event) {
        Collection stages = event.getApplicationContext().getBeansOfType(CommodityInfoSourceStrategy.class).values();
        stages.forEach(p -> {
            CommoditySourceStage sourceStage = (CommoditySourceStage)AnnotationUtils.getAnnotation((AnnotatedElement)AopUtils.getTargetClass((Object)p), CommoditySourceStage.class);
            if (!Objects.isNull(sourceStage)) {
                STAGE_MAP.put(sourceStage.value(), (CommodityInfoSourceStrategy)p);
            }
        });
    }
}

