/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.commodity.info.source;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.common.enums.LocalCommodityStatusEnum;
import com.bxm.fossicker.commodity.model.constant.CommoditySourceEnum;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailInfoDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityInfoDTO;
import com.bxm.fossicker.commodity.model.entry.CommodityInfo;
import com.bxm.fossicker.commodity.model.param.GetCommodityDetailParam;
import com.bxm.fossicker.commodity.model.vo.CommodityCouponInfo;
import com.bxm.fossicker.commodity.service.CommodityCouponInfoService;
import com.bxm.fossicker.commodity.service.commodity.info.source.AbstractCommodityInfoSourceStrategy;
import com.bxm.fossicker.commodity.service.commodity.info.source.annotation.CommoditySourceStage;
import com.bxm.fossicker.constant.CommonCommodityRedisKey;
import com.bxm.fossicker.integration.param.GetCouponInfoParam;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@CommoditySourceStage(value=CommoditySourceEnum.LOCAL)
public class LocalCommodityInfoSourceStrategy
extends AbstractCommodityInfoSourceStrategy {
    private static final Logger log = LoggerFactory.getLogger(LocalCommodityInfoSourceStrategy.class);
    @Autowired
    private CommodityCouponInfoService commodityCouponInfoService;

    @Override
    public CommodityInfoDTO doGetCommodityDetail(GetCommodityDetailParam param) {
        Long commodityId = param.getCommodityId();
        CommodityInfoDTO commodityInfoDTO = this.commodityDetail(commodityId);
        if (Objects.nonNull(commodityInfoDTO)) {
            if (param.isIfLocalDownThenReturnNull() && Objects.equals(commodityInfoDTO.getStatus(), LocalCommodityStatusEnum.InValid.getStatus())) {
                return null;
            }
            if (param.isQueryCouponInfo() && Objects.equals(commodityInfoDTO.getStatus(), LocalCommodityStatusEnum.Valid.getStatus())) {
                CommodityCouponInfo commodityCouponInfo;
                if (log.isDebugEnabled()) {
                    log.debug("\u7248\u672c\u4f4e\u4e8e1.5.0\uff0c\u65e2\u65f6\u67e5\u8be2\u4f18\u60e0\u5238\uff0c\u5546\u54c1id: {}", (Object)param.getCommodityId());
                }
                if (Objects.nonNull(commodityCouponInfo = this.commodityCouponInfoService.getCommodityCouponInfo(GetCouponInfoParam.builder().goodsId(Objects.toString(commodityId)).sourceFrom(commodityInfoDTO.getSoruce()).replaceHttp2TbOpen(false).build()))) {
                    commodityInfoDTO.setCouponUrl(commodityCouponInfo.getCouponUrl());
                }
            } else {
                commodityInfoDTO.setCouponUrl(null);
            }
        }
        return commodityInfoDTO;
    }

    private CommodityInfoDTO commodityDetail(Long commodityId) {
        KeyGenerator keyGenerator;
        CommodityInfo commodityInfo;
        if (log.isDebugEnabled()) {
            log.debug("commodityId: {} \u4ece\u672c\u5730\u83b7\u53d6\u6570\u636e", (Object)commodityId);
        }
        if (Objects.isNull(commodityInfo = (CommodityInfo)this.redisHashMapAdapter.get(keyGenerator = CommonCommodityRedisKey.LOCAL_COMMODITY_INFO.copy().appendKey((Object)(Math.abs(commodityId.toString().hashCode()) % 10)), commodityId.toString(), CommodityInfo.class))) {
            if (log.isDebugEnabled()) {
                log.debug("commodityId: {} \u5bf9\u5e94\u7684\u672c\u5730\u6570\u636e\u4e0d\u5b58\u5728", (Object)commodityId);
            }
            return null;
        }
        return this.convert(commodityInfo);
    }

    @Override
    protected List<CommodityDetailInfoDTO> doGetCommodityDetailInfo(Long commodityId) {
        CommodityInfoDTO commodityInfoDTO = this.commodityDetail(commodityId);
        if (Objects.isNull(commodityInfoDTO)) {
            return null;
        }
        return commodityInfoDTO.getDetailInfo();
    }

    private CommodityInfoDTO convert(CommodityInfo commodityInfo) {
        String sellerScore = "4.8";
        String logisticsScore = "4.8";
        String commodityScore = "4.8";
        if (StringUtils.isNotBlank((String)commodityInfo.getSellerScore())) {
            sellerScore = new BigDecimal(commodityInfo.getSellerScore()).setScale(1, RoundingMode.HALF_DOWN).toString();
        }
        if (StringUtils.isNotBlank((String)commodityInfo.getCommodityScore())) {
            logisticsScore = new BigDecimal(commodityInfo.getCommodityScore()).setScale(1, RoundingMode.HALF_DOWN).toString();
        }
        if (StringUtils.isNotBlank((String)commodityInfo.getLogisticsScore())) {
            commodityScore = new BigDecimal(commodityInfo.getLogisticsScore()).setScale(1, RoundingMode.HALF_DOWN).toString();
        }
        return CommodityInfoDTO.builder().platformCommissionPrice(Double.valueOf(Objects.isNull(commodityInfo.getCommissionPrice()) ? 0.0 : commodityInfo.getCommissionPrice().setScale(2, RoundingMode.HALF_DOWN).doubleValue())).commodityPrice(Double.valueOf(Objects.isNull(commodityInfo.getCommodityPrice()) ? 0.0 : commodityInfo.getCommodityPrice().setScale(2, RoundingMode.HALF_DOWN).doubleValue())).commodityTitle(commodityInfo.getCommodityTitle()).couponPrice(Double.valueOf(Objects.isNull(commodityInfo.getCouponPrice()) ? 0.0 : commodityInfo.getCouponPrice().setScale(2, RoundingMode.HALF_DOWN).doubleValue())).couponUrl(commodityInfo.getCouponUrl()).discountPrice(Double.valueOf(Objects.isNull(commodityInfo.getDiscountPrice()) ? 0.0 : commodityInfo.getDiscountPrice().setScale(2, RoundingMode.HALF_DOWN).doubleValue())).goodsId(Objects.isNull(commodityInfo.getGoodId()) ? null : Long.valueOf(Long.parseLong(commodityInfo.getGoodId()))).imgUrlList(StringUtils.isNotBlank((String)commodityInfo.getImgUrlList()) ? JSON.parseArray((String)commodityInfo.getImgUrlList(), String.class) : Lists.newArrayList()).mainPic(commodityInfo.getMainPic()).recommendContent(commodityInfo.getRecommendContent()).reservePrice(Double.valueOf(Objects.isNull(commodityInfo.getReservePrice()) ? 0.0 : commodityInfo.getReservePrice().setScale(2, RoundingMode.HALF_DOWN).doubleValue())).salesNum(commodityInfo.getSalesNum()).sellerScore(sellerScore).commodityScore(logisticsScore).logisticsScore(commodityScore).shopIcon(commodityInfo.getShopIcon()).shopName(commodityInfo.getShopName()).shopType(Integer.valueOf(commodityInfo.getShopType().intValue())).shopUrl(commodityInfo.getShopUrl()).status(commodityInfo.getStatus()).detailInfo(StringUtils.isNotBlank((String)commodityInfo.getDetailInfo()) ? JSON.parseArray((String)commodityInfo.getDetailInfo(), CommodityDetailInfoDTO.class) : Lists.newArrayList()).soruce(commodityInfo.getSoruce()).build();
    }
}

