/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.commodity.info.source;

import com.bxm.fossicker.commodity.common.dto.CommissionAndCoupon;
import com.bxm.fossicker.commodity.common.utils.CommodityCalUtils;
import com.bxm.fossicker.commodity.model.constant.CommodityRedisKey;
import com.bxm.fossicker.commodity.model.constant.CommoditySourceEnum;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailInfoDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityInfoDTO;
import com.bxm.fossicker.commodity.model.param.GetCommodityDetailParam;
import com.bxm.fossicker.commodity.service.CommodityPriceInfoService;
import com.bxm.fossicker.commodity.service.commodity.info.source.AbstractCommodityInfoSourceStrategy;
import com.bxm.fossicker.commodity.service.commodity.info.source.annotation.CommoditySourceStage;
import com.bxm.fossicker.integration.dto.CommodityDetailIntegrationDTO;
import com.bxm.fossicker.integration.dto.CommodityImageIntegrationDTO;
import com.bxm.fossicker.integration.service.CrawlerIntegrationService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@CommoditySourceStage(value=CommoditySourceEnum.TAOBAO)
public class TaobaoCommodityInfoSourceStrategy
extends AbstractCommodityInfoSourceStrategy {
    private static final Logger log = LoggerFactory.getLogger(TaobaoCommodityInfoSourceStrategy.class);
    @Autowired
    private CrawlerIntegrationService crawlerIntegrationService;
    @Autowired
    private CommodityPriceInfoService commodityPriceInfoService;
    private static final int EXPIRE_SEC = 1200;

    @Override
    protected CommodityInfoDTO doGetCommodityDetail(GetCommodityDetailParam param) {
        KeyGenerator key;
        CommodityInfoDTO commodityInfoDTO;
        Long commodityId = param.getCommodityId();
        if (log.isDebugEnabled()) {
            log.debug("commodityId: {} \u4ece\u722c\u866b\u722c\u53d6\u6570\u636e", (Object)commodityId);
        }
        if (Objects.isNull(commodityInfoDTO = (CommodityInfoDTO)this.redisStringAdapter.get(key = CommodityRedisKey.TAOBAO_COMMODITY_INFO.copy().appendKey((Object)commodityId), CommodityInfoDTO.class))) {
            List<CommodityDetailInfoDTO> detailInfo;
            CommodityDetailIntegrationDTO queryResult = this.crawlerIntegrationService.getCommodityDetail(commodityId);
            if (Objects.isNull(queryResult)) {
                log.warn("commodityId: {} \u6570\u636e\u722c\u53d6\u5931\u8d25", (Object)commodityId);
                commodityInfoDTO = new CommodityInfoDTO();
                commodityInfoDTO.setGoodsId(commodityId);
            } else {
                commodityInfoDTO = this.convert(queryResult);
            }
            CommissionAndCoupon commissionAndCoupon = this.commodityPriceInfoService.getCommodityCommissionAndCoupon(commodityId);
            Double reservePrice = this.commodityPriceInfoService.getReservePrice(commodityId);
            commodityInfoDTO.setReservePrice(reservePrice);
            if (!Objects.isNull(commissionAndCoupon)) {
                BigDecimal platformCommissionPrice = BigDecimal.ZERO;
                if (!(Objects.isNull(commodityInfoDTO.getReservePrice()) || Objects.isNull(commissionAndCoupon.getCouponPrice()) || Objects.isNull(commissionAndCoupon.getCommissionRateByThird()) || Objects.isNull(reservePrice))) {
                    platformCommissionPrice = BigDecimal.valueOf(reservePrice).subtract(BigDecimal.valueOf(commissionAndCoupon.getCouponPrice())).multiply(BigDecimal.valueOf(commissionAndCoupon.getCommissionRateByThird())).setScale(2, 1);
                }
                commodityInfoDTO.setDiscountPrice(CommodityCalUtils.calCommodityPriceWithSubtractingCoupon((Double)commodityInfoDTO.getReservePrice(), (Double)commissionAndCoupon.getCouponPrice()));
                commodityInfoDTO.setCouponPrice(commissionAndCoupon.getCouponPrice());
                commodityInfoDTO.setPlatformCommissionPrice(Double.valueOf(platformCommissionPrice.doubleValue()));
                commodityInfoDTO.setCouponUrl(commissionAndCoupon.getCouponUrl());
            }
            if (!CollectionUtils.isEmpty(detailInfo = this.doGetCommodityDetailInfo(commodityId))) {
                commodityInfoDTO.setDetailInfo(detailInfo);
            }
            this.redisStringAdapter.set(key, (Object)commodityInfoDTO, 1200L);
        }
        return commodityInfoDTO;
    }

    @Override
    protected List<CommodityDetailInfoDTO> doGetCommodityDetailInfo(Long commodityId) {
        List commodityImageIntegrationDTOS;
        if (log.isDebugEnabled()) {
            log.debug("commodityId: {} \u722c\u53d6\u83b7\u53d6\u56fe\u6587\u8be6\u60c5", (Object)commodityId);
        }
        if (!CollectionUtils.isEmpty((Collection)(commodityImageIntegrationDTOS = this.crawlerIntegrationService.getDetailList(commodityId)))) {
            return commodityImageIntegrationDTOS.stream().map(this::convert).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private CommodityDetailInfoDTO convert(CommodityImageIntegrationDTO integrationDTO) {
        CommodityDetailInfoDTO infoDTO = CommodityDetailInfoDTO.builder().build();
        BeanUtils.copyProperties((Object)integrationDTO, (Object)infoDTO);
        return infoDTO;
    }

    private CommodityInfoDTO convert(CommodityDetailIntegrationDTO commodityDetailIntegrationDTO) {
        String mainPic = "";
        if (!CollectionUtils.isEmpty((Collection)commodityDetailIntegrationDTO.getImgUrlList())) {
            mainPic = (String)commodityDetailIntegrationDTO.getImgUrlList().get(0);
        }
        return CommodityInfoDTO.builder().goodsId(commodityDetailIntegrationDTO.getCommodityId()).commodityTitle(commodityDetailIntegrationDTO.getCommodityTitle()).imgUrlList(commodityDetailIntegrationDTO.getImgUrlList()).mainPic(mainPic).reservePrice(commodityDetailIntegrationDTO.getReservePrice()).salesNum(commodityDetailIntegrationDTO.getSalesNum()).shopName(commodityDetailIntegrationDTO.getShopName()).shopIcon(commodityDetailIntegrationDTO.getShopIcon()).shopUrl(commodityDetailIntegrationDTO.getShopUrl()).commodityScore(commodityDetailIntegrationDTO.getCommodityScore()).sellerScore(commodityDetailIntegrationDTO.getSellerScore()).logisticsScore(commodityDetailIntegrationDTO.getLogisticsScore()).shopType(this.getShopTypeFromTypeCode(commodityDetailIntegrationDTO.getShopType())).soruce(Byte.valueOf((byte)0)).build();
    }
}

