/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.commodity.list;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.config.CommodityListProperties;
import com.bxm.fossicker.commodity.model.constant.CommodityDetailResultCode;
import com.bxm.fossicker.commodity.model.dto.CommodityExtendInfo;
import com.bxm.fossicker.commodity.model.dto.CommodityGoldInfoDTO;
import com.bxm.fossicker.commodity.model.dto.CommodityListItemResult;
import com.bxm.fossicker.commodity.model.dto.Index;
import com.bxm.fossicker.commodity.model.param.CommodityDetailQueryParam;
import com.bxm.fossicker.commodity.model.param.CommodityListParam;
import com.bxm.fossicker.commodity.model.vo.BaseCommodityListItem;
import com.bxm.fossicker.commodity.service.BlackCommodityService;
import com.bxm.fossicker.commodity.service.CommodityGoldService;
import com.bxm.fossicker.commodity.service.CommodityInfoService;
import com.bxm.fossicker.commodity.service.CommodityPoolService;
import com.bxm.fossicker.commodity.service.CommodityPriceInfoService;
import com.bxm.fossicker.commodity.service.commodity.info.CommodityInfoSourceProxyService;
import com.bxm.fossicker.commodity.service.commodity.list.CommodityListService;
import com.bxm.fossicker.commodity.service.commodity.list.CommodityListServiceProxy;
import com.bxm.fossicker.commodity.service.strategy.CommodityLabelService;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.vo.Message;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractCommodityListService<T extends BaseCommodityListItem, P extends CommodityListParam>
extends CommodityListServiceProxy
implements CommodityListService<T, P> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected CommodityInfoSourceProxyService commodityInfoSourceProxyService;
    @Autowired
    private CommodityInfoService commodityInfoService;
    @Autowired
    protected CommodityPoolService commodityPoolService;
    @Autowired
    private BlackCommodityService blackCommodityService;
    @Autowired
    private CommodityPriceInfoService commodityPriceInfoService;
    @Autowired
    private CommodityGoldService commodityGoldService;
    @Autowired
    private VipFacadeService vipFacadeService;
    @Autowired
    protected CommodityListProperties commodityListProperties;
    @Autowired
    private CommodityLabelService commodityLabelService;
    @Autowired
    protected CommodityInfoProperties commodityInfoProperties;

    @Override
    public List<T> commodityList(P p) {
        List<Object> ts;
        Message message = this.checkParam(p);
        if (!message.isSuccess()) {
            this.log.warn("{} \u6821\u9a8c\u53c2\u6570\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f: {}", (Object)this.description(), (Object)message.getLastMessage());
            return Lists.newArrayList();
        }
        try {
            ts = this.doGetCommodityList(p);
            if (!CollectionUtils.isEmpty(ts)) {
                ts = this.afterGetCommodityList(p, ts);
            }
        }
        catch (Exception e) {
            this.log.error("\u83b7\u53d6{} \u5217\u8868\u5931\u8d25", (Object)this.description(), (Object)e);
            ts = Lists.newArrayList();
        }
        return ts;
    }

    protected CommodityDetailQueryParam initCommodityDetailQueryParam(P p, Long goodsId) {
        CommodityDetailQueryParam queryParam = new CommodityDetailQueryParam();
        queryParam.setUserId(p.getUserId());
        queryParam.setVipUser(p.getVip());
        queryParam.setNewbieRightUser(p.getNewbieRight());
        queryParam.setGoodsId(goodsId);
        queryParam.setPublicRequest(p.isPublicRequest());
        queryParam.setValidateCommissionPriceInfo(true);
        queryParam.setQueryNewbie(true);
        return queryParam;
    }

    protected CommodityListItemResult commodityListItemBaseInfo(CommodityDetailQueryParam param) {
        return this.commodityInfoService.getCommodityListItemBaseInfo(param);
    }

    private void setLabelUrl(BaseCommodityListItem commodity) {
        commodity.setLabelUrl(Objects.equals(commodity.getNewbieRight(), Boolean.TRUE) ? new ArrayList() : this.commodityLabelService.labelTypeFromRedis(commodity.getGoodsId()));
    }

    protected void setGoldInfo(BaseCommodityListItem commodity, Long userId) {
        CommodityGoldInfoDTO goldInfoDTO = this.commodityGoldService.getGoldInfoByCommodityId(commodity.getGoodsId(), userId);
        commodity.setGoldStatus(goldInfoDTO.getDrawFlag());
        commodity.setGoldNum(goldInfoDTO.getBrowseGold());
    }

    private boolean validateCommission(CommodityExtendInfo commodityExtendInfo, Double reservePrice, Double couponPrice, Long goodsId) {
        if (Objects.isNull(commodityExtendInfo) || Objects.isNull(commodityExtendInfo.getCommissionPrice()) || Objects.isNull(commodityExtendInfo.getCommodityPrice()) || Objects.isNull(reservePrice) || Objects.isNull(couponPrice)) {
            return false;
        }
        if (Objects.equals(commodityExtendInfo.getCommissionPrice(), 0.0)) {
            return false;
        }
        if (Objects.equals(couponPrice, 0.0)) {
            return false;
        }
        if (commodityExtendInfo.isNewbieRight()) {
            if (this.commodityPriceInfoService.isRuleNewbiePrice(commodityExtendInfo.getCommodityPrice())) {
                commodityExtendInfo.setCommissionPrice(commodityExtendInfo.getCommodityPrice());
                commodityExtendInfo.setCommodityPrice(Double.valueOf(0.0));
            } else {
                this.log.info("\u65b0\u4eba\u4e13\u4eab\u5546\u54c1: {} \u6298\u540e\u4ef7\u8d85\u51fa\u6700\u5927\u9650\u989d\uff0c\u8fdb\u884c\u4e0b\u67b6\u5904\u7406\uff1a[{}]", (Object)goodsId, (Object)JSONObject.toJSONString((Object)commodityExtendInfo));
                this.commodityPoolService.setNewbieInvalidStatus(goodsId);
                return false;
            }
        }
        return true;
    }

    protected boolean checkCommodityListBaseItemSuccess(CommodityListItemResult result) {
        return Objects.equals(result.getResultCode(), CommodityDetailResultCode.SUCCESS) && Objects.nonNull(result.getListItem());
    }

    protected Message checkParam(P p) {
        if (!p.isPublicRequest() && Objects.isNull(p.getUserId())) {
            return Message.build((boolean)false).setMessage("\u7528\u6237id\u4e3a\u7a7a");
        }
        if (Objects.isNull(p.getNewbieRight())) {
            p.setNewbieRight(Boolean.valueOf(this.commodityPriceInfoService.isNewbieRightForUser(p.getUserId())));
        }
        if (Objects.isNull(p.getVip())) {
            p.setVip(Boolean.valueOf(this.vipFacadeService.isVip(p.getUserId())));
        }
        return Message.build();
    }

    protected Index getIndex(int pageOn, int pageSize, int totalSize) {
        Index index = new Index();
        int start = pageOn > 1 ? (pageOn - 1) * pageSize : 0;
        int end = start + pageSize;
        end = end > totalSize ? totalSize : end;
        index.setStart(start);
        index.setEnd(end);
        return index;
    }

    protected List<T> afterGetCommodityList(P p, List<T> ts) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u5217\u8868\u540e\u7f6e\u5904\u7406\uff0c\u8bf7\u6c42\u53c2\u6570: {}", (Object)JSON.toJSONString(p));
        }
        return ts.stream().peek(p1 -> {
            if (p.isQueryGoldInfo()) {
                this.setGoldInfo((BaseCommodityListItem)p1, p.getUserId());
            }
            if (p.isQueryLabel()) {
                this.setLabelUrl((BaseCommodityListItem)p1);
            }
        }).collect(Collectors.toList());
    }

    protected abstract List<T> doGetCommodityList(P var1);

    protected abstract String description();
}

