/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.commodity.list;

import com.bxm.fossicker.commodity.model.param.CommodityListParam;
import com.bxm.fossicker.commodity.service.commodity.list.CommodityListService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class CommodityListServiceProxy {
    private static final Logger log = LoggerFactory.getLogger(CommodityListServiceProxy.class);
    private Map<Class<CommodityListParam>, CommodityListService> serviceMap = Maps.newHashMap();

    public <T> List<T> getCommodityList(CommodityListParam param) {
        CommodityListService service = this.getService(param);
        if (Objects.isNull(service)) {
            log.warn("\u7c7b\u578b: {} \u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\u5217\u8868service", param.getClass());
            return Lists.newArrayList();
        }
        return service.commodityList(param);
    }

    protected CommodityListService getService(CommodityListParam param) {
        return this.serviceMap.get(param.getClass());
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void onApplicationStartedEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        Collection commodityListServices = applicationContext.getBeansOfType(CommodityListService.class).values();
        commodityListServices.forEach(p -> this.serviceMap.put(p.support(), (CommodityListService)p));
    }
}

