/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.commodity.list.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.common.utils.SignMD5Util;
import com.bxm.fossicker.commodity.model.dto.CommodityListItemResult;
import com.bxm.fossicker.commodity.model.dto.DtkCategorySearchResult;
import com.bxm.fossicker.commodity.model.param.CategoryCommodityListParam;
import com.bxm.fossicker.commodity.model.param.CommodityDetailQueryParam;
import com.bxm.fossicker.commodity.model.vo.CategoryCommodityListItem;
import com.bxm.fossicker.commodity.service.commodity.list.AbstractCommodityListService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CategoryCommodityListService
extends AbstractCommodityListService<CategoryCommodityListItem, CategoryCommodityListParam> {
    @Override
    protected List<CategoryCommodityListItem> doGetCommodityList(CategoryCommodityListParam param) {
        List<DtkCategorySearchResult> categorySearchResults = this.dtkCategorySearchFromApi(param);
        return categorySearchResults.stream().map(p -> {
            CommodityDetailQueryParam queryParam = this.initCommodityDetailQueryParam(param, p.getGoodsId());
            queryParam.setQueryLocalOnly(true);
            CommodityListItemResult result = this.commodityListItemBaseInfo(queryParam);
            if (!this.checkCommodityListBaseItemSuccess(result)) {
                return null;
            }
            CategoryCommodityListItem listItem = new CategoryCommodityListItem();
            BeanUtils.copyProperties((Object)result.getListItem(), (Object)listItem);
            if (Objects.nonNull(p.getQuanMLink())) {
                listItem.setHandsel(p.getQuanMLink());
            }
            return listItem;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<DtkCategorySearchResult> dtkCategorySearchFromApi(CategoryCommodityListParam param) {
        Map<String, Object> paramMapper = this.searchParam(param);
        String jsonStr = "";
        try {
            jsonStr = OkHttpUtils.get((String)this.commodityInfoProperties.getDtkCategorySearchUrl(), paramMapper);
            if (StringUtils.isBlank((String)jsonStr)) {
                for (int i = 1; i <= 3 && !StringUtils.isNotBlank((String)(jsonStr = OkHttpUtils.get((String)this.commodityInfoProperties.getDtkCategorySearchUrl(), paramMapper))); ++i) {
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u67e5\u8be2\u5927\u6dd8\u5ba2\u63a5\u53e3\u5931\u8d25", (Throwable)e);
            return Lists.newArrayList();
        }
        if (StringUtils.isBlank((String)jsonStr)) {
            return Lists.newArrayList();
        }
        ArrayList results = Lists.newArrayList();
        JSONObject dtkJson = JSONObject.parseObject((String)jsonStr);
        if (Integer.parseInt(dtkJson.getString("code")) == 0 && "\u6210\u529f".equals(dtkJson.getString("msg"))) {
            JSONObject dataJson = JSONObject.parseObject((String)dtkJson.getString("data"));
            JSONArray dtkArray = JSONArray.parseArray((String)dataJson.getString("list"));
            for (int i = 0; i < dtkArray.size(); ++i) {
                JSONObject job = dtkArray.getJSONObject(i);
                DtkCategorySearchResult result = new DtkCategorySearchResult();
                result.setGoodsId(job.getLong("goodsId"));
                result.setQuanMLink(job.getDouble("quanMLink"));
                results.add(result);
            }
        }
        return results;
    }

    private Map<String, Object> searchParam(CategoryCommodityListParam param) {
        TreeMap<String, Object> paraMap = new TreeMap<String, Object>();
        paraMap.put("version", this.commodityInfoProperties.getDtkCommodityVersion());
        paraMap.put("appKey", this.commodityInfoProperties.getDtkCommodityAppKey());
        if (StringUtils.isNotBlank((String)param.getSortType())) {
            paraMap.put("sort", param.getSortType());
        }
        if (StringUtils.isNotBlank((String)param.getCids())) {
            paraMap.put("cids", param.getCids());
        }
        if (StringUtils.isNotBlank((String)param.getSubcid())) {
            paraMap.put("subcid", param.getSubcid());
        }
        if (StringUtils.isNotBlank((String)param.getPriceLowerLimit())) {
            paraMap.put("priceLowerLimit", param.getPriceLowerLimit());
        }
        if (StringUtils.isNotBlank((String)param.getPriceUpperLimit())) {
            paraMap.put("priceUpperLimit", param.getPriceUpperLimit());
        }
        if (!Objects.isNull(param.getPageOn())) {
            paraMap.put("pageId", param.getPageOn());
        }
        if (!Objects.isNull(param.getPageSize())) {
            paraMap.put("pageSize", param.getPageSize());
        }
        paraMap.put("sign", SignMD5Util.getSignStr(paraMap, (String)this.commodityInfoProperties.getDtkCommodityAppSecret()));
        return paraMap;
    }

    @Override
    protected String description() {
        return "\u5206\u7c7b\u5217\u8868";
    }

    @Override
    public Class<CategoryCommodityListParam> support() {
        return CategoryCommodityListParam.class;
    }
}

