/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.commodity.list.impl;

import com.bxm.fossicker.commodity.model.dto.CommodityListItemResult;
import com.bxm.fossicker.commodity.model.dto.WySearchCommodityInfoDTO;
import com.bxm.fossicker.commodity.model.param.CommodityDetailQueryParam;
import com.bxm.fossicker.commodity.model.param.GuessLikeListParam;
import com.bxm.fossicker.commodity.model.param.WySearchCommodityInfoParam;
import com.bxm.fossicker.commodity.model.vo.BaseCommodityListItem;
import com.bxm.fossicker.commodity.service.commodity.list.AbstractCommodityListService;
import com.bxm.fossicker.commodity.service.externel.WyCommodityService;
import com.bxm.fossicker.vo.PageWarper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GuessLikeCommodityListService
extends AbstractCommodityListService<BaseCommodityListItem, GuessLikeListParam> {
    @Autowired
    private WyCommodityService wyCommodityService;

    @Override
    protected List<BaseCommodityListItem> doGetCommodityList(GuessLikeListParam param) {
        PageWarper resultPage = new PageWarper();
        resultPage.setPageNum(param.getGuessCommodityQueryParam().getPageNum().intValue());
        resultPage.setPageSize(param.getGuessCommodityQueryParam().getPageSize().intValue());
        List<WySearchCommodityInfoDTO> wyCommodityList = this.wyCommodityService.guessLike(param.getGuessCommodityQueryParam());
        if (CollectionUtils.isEmpty(wyCommodityList)) {
            return Lists.newArrayList();
        }
        return wyCommodityList.stream().map(p -> {
            CommodityDetailQueryParam queryParam = this.initCommodityDetailQueryParam(param, p.getItemId());
            queryParam.setQueryLocalOnly(true);
            CommodityListItemResult result = this.commodityListItemBaseInfo(queryParam);
            if (!this.checkCommodityListBaseItemSuccess(result)) {
                queryParam.setWySearchCommodityInfoParam(WySearchCommodityInfoParam.builder().wyInfo(p).convertType(Byte.valueOf((byte)2)).build());
                result = this.commodityListItemBaseInfo(queryParam);
                if (!this.checkCommodityListBaseItemSuccess(result)) {
                    return null;
                }
            }
            return result.getListItem();
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    protected String description() {
        return "\u731c\u4f60\u559c\u6b22\u5217\u8868";
    }

    @Override
    public Class<GuessLikeListParam> support() {
        return GuessLikeListParam.class;
    }
}

