/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.commodity.list.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.domain.CommodityInfoMapper;
import com.bxm.fossicker.commodity.model.dto.CommodityListItemResult;
import com.bxm.fossicker.commodity.model.param.CommodityDetailQueryParam;
import com.bxm.fossicker.commodity.model.param.PoolCommodityListParam;
import com.bxm.fossicker.commodity.model.vo.PoolCommodityListItem;
import com.bxm.fossicker.commodity.service.commodity.list.AbstractCommodityListService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PoolCommodityListService
extends AbstractCommodityListService<PoolCommodityListItem, PoolCommodityListParam> {
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private CommodityInfoMapper commodityInfoMapper;

    @Override
    protected List<PoolCommodityListItem> doGetCommodityList(PoolCommodityListParam param) {
        List goodsIds;
        KeyGenerator key = CommodityRedisKeyConstants.COMMODITY_GOODS_LIST_EXTEND.copy().appendKey((Object)param.getPoolId()).appendKey((Object)(param.getVip() != false ? "isVip" : "noVip"));
        if (this.commodityListProperties.getCacheSwitch().booleanValue()) {
            String topPoolGoodsList;
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u5217\u8868\u7f13\u5b58\u5f00\u542f\uff0c\u4f18\u5148\u67e5\u8be2\u7f13\u5b58");
            }
            if (StringUtils.isNotBlank((String)(topPoolGoodsList = this.redisStringAdapter.getString(key)))) {
                return JSONArray.parseArray((String)topPoolGoodsList, PoolCommodityListItem.class);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(goodsIds = this.commodityInfoMapper.getPoolInfo(param.getPoolId())))) {
            return Lists.newArrayList();
        }
        List<PoolCommodityListItem> poolCommodityListItems = goodsIds.stream().map(p -> {
            CommodityDetailQueryParam queryParam = this.initCommodityDetailQueryParam(param, Long.parseLong(p));
            queryParam.setQueryLocalOnly(false);
            queryParam.setDetailType(Integer.valueOf(Objects.equals(param.getPoolId(), 23L) ? 1 : 0));
            return this.commodityListItemBaseInfo(queryParam);
        }).filter(p -> {
            if (Objects.isNull(p) || Objects.isNull(p.getListItem())) {
                return false;
            }
            if (!this.checkCommodityListBaseItemSuccess((CommodityListItemResult)p)) {
                this.log.info("\u5546\u54c1id: {} \u5546\u54c1\u6c60id: {}\u4e0b\u67b6\u5546\u54c1", (Object)p.getListItem().getGoodsId(), (Object)param.getPoolId());
                this.commodityPoolService.setPoolCommodityInvalidStatus(param.getPoolId(), p.getListItem().getGoodsId());
                return false;
            }
            return true;
        }).map(p -> {
            PoolCommodityListItem listItem = new PoolCommodityListItem();
            BeanUtils.copyProperties((Object)p.getListItem(), (Object)listItem);
            listItem.setPoolId(param.getPoolId());
            return listItem;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(poolCommodityListItems)) {
            this.redisStringAdapter.set(key, (Object)JSON.toJSONString(poolCommodityListItems), this.commodityListProperties.getPoolCommodityListCacheTimeSecond().longValue());
        }
        return poolCommodityListItems;
    }

    @Override
    protected String description() {
        return "\u5546\u54c1\u6c60\u5217\u8868";
    }

    @Override
    public Class<PoolCommodityListParam> support() {
        return PoolCommodityListParam.class;
    }
}

