/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.commodity.list.impl;

import com.alibaba.fastjson.JSONArray;
import com.bxm.fossicker.commodity.common.constants.CommodityRedisKeyConstants;
import com.bxm.fossicker.commodity.model.dto.CommodityListItemResult;
import com.bxm.fossicker.commodity.model.param.CommodityDetailQueryParam;
import com.bxm.fossicker.commodity.model.param.RecommendCommodityParam;
import com.bxm.fossicker.commodity.model.vo.BaseCommodityListItem;
import com.bxm.fossicker.commodity.service.commodity.list.AbstractCommodityListService;
import com.bxm.fossicker.commodity.service.externel.TbCommodityService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.google.common.collect.Lists;
import com.taobao.api.domain.NTbkItem;
import com.taobao.api.request.TbkItemRecommendGetRequest;
import com.taobao.api.response.TbkItemRecommendGetResponse;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RecommendCommodityListService
extends AbstractCommodityListService<BaseCommodityListItem, RecommendCommodityParam> {
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private TbCommodityService tbCommodityService;

    @Override
    protected List<BaseCommodityListItem> doGetCommodityList(RecommendCommodityParam param) {
        List redisInfoList;
        String recommendStr;
        KeyGenerator recommendRedisKey = CommodityRedisKeyConstants.COMMODITY_RECOMMEND.copy().appendKey((Object)param.getCommodityId());
        if (this.commodityListProperties.getCacheSwitch().booleanValue() && StringUtils.isNotBlank((String)(recommendStr = this.redisStringAdapter.getString(recommendRedisKey))) && !CollectionUtils.isEmpty((Collection)(redisInfoList = JSONArray.parseArray((String)recommendStr, BaseCommodityListItem.class)))) {
            return redisInfoList;
        }
        List<NTbkItem> tbkItems = this.tbInfoList(param.getCommodityId());
        if (CollectionUtils.isEmpty(tbkItems)) {
            return Lists.newArrayList();
        }
        return tbkItems.stream().map(p -> {
            CommodityDetailQueryParam queryParam = this.initCommodityDetailQueryParam(param, p.getNumIid());
            queryParam.setQueryLocalOnly(false);
            return this.commodityListItemBaseInfo(queryParam);
        }).filter(this::checkCommodityListBaseItemSuccess).map(CommodityListItemResult::getListItem).collect(Collectors.toList());
    }

    private List<NTbkItem> tbInfoList(Long commodityId) {
        TbkItemRecommendGetRequest req = new TbkItemRecommendGetRequest();
        req.setFields("num_iid,title,pict_url,small_images,reserve_price,zk_final_price,user_type,provcity,item_url");
        req.setNumIid(commodityId);
        req.setCount(Long.valueOf(10L));
        req.setPlatform(Long.valueOf(2L));
        TbkItemRecommendGetResponse rsp = this.tbCommodityService.getRecommendCommodity(req);
        if (Objects.isNull(rsp) || CollectionUtils.isEmpty((Collection)rsp.getResults())) {
            this.log.warn("\u4ece\u6dd8\u5b9d\u63a5\u53e3\u83b7\u53d6\u5230\u7684\u63a8\u8350\u5546\u54c1\u4e3a\u7a7a,\u5546\u54c1id:{}", (Object)commodityId);
            return null;
        }
        return rsp.getResults();
    }

    @Override
    protected String description() {
        return "\u63a8\u8350\u5217\u8868";
    }

    @Override
    public Class<RecommendCommodityParam> support() {
        return RecommendCommodityParam.class;
    }
}

