/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.commodity.list.impl;

import com.bxm.fossicker.commodity.domain.CommodityFavoriteMapper;
import com.bxm.fossicker.commodity.model.dto.CommodityListItemResult;
import com.bxm.fossicker.commodity.model.param.CommodityDetailQueryParam;
import com.bxm.fossicker.commodity.model.param.UserCollectionCommodityListParam;
import com.bxm.fossicker.commodity.model.vo.CommodityCollectionVO;
import com.bxm.fossicker.commodity.service.commodity.list.AbstractCommodityListService;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserCollectionCommodityListService
extends AbstractCommodityListService<CommodityCollectionVO, UserCollectionCommodityListParam> {
    @Autowired
    private CommodityFavoriteMapper commodityFavoriteMapper;

    @Override
    protected List<CommodityCollectionVO> doGetCommodityList(UserCollectionCommodityListParam param) {
        List goodsIdList = this.commodityFavoriteMapper.getCollectionByUserId(param.getUserId());
        if (CollectionUtils.isEmpty((Collection)goodsIdList)) {
            return null;
        }
        return goodsIdList.stream().map(p -> {
            CommodityDetailQueryParam queryParam = this.initCommodityDetailQueryParam(param, Long.parseLong(p));
            queryParam.setQueryLocalOnly(false);
            queryParam.setIfNotValidThenReturnBaseInfo(true);
            CommodityListItemResult itemResult = this.commodityListItemBaseInfo(queryParam);
            CommodityCollectionVO collectionVO = new CommodityCollectionVO();
            if (!this.checkCommodityListBaseItemSuccess(itemResult)) {
                if (Objects.nonNull(itemResult.getListItem())) {
                    collectionVO.setCommodityTitle(itemResult.getListItem().getCommodityTitle());
                    collectionVO.setMainPic(itemResult.getListItem().getImgUrl());
                    collectionVO.setImgUrl(itemResult.getListItem().getImgUrl());
                    collectionVO.setShopName(itemResult.getListItem().getShopName());
                    collectionVO.setShopType(itemResult.getListItem().getShopType());
                    collectionVO.setGoodsId(itemResult.getListItem().getGoodsId());
                }
                collectionVO.setValidStatus(Integer.valueOf(0));
                return collectionVO;
            }
            BeanUtils.copyProperties((Object)itemResult.getListItem(), (Object)collectionVO);
            collectionVO.setValidStatus(Integer.valueOf(1));
            collectionVO.setMainPic(collectionVO.getImgUrl());
            return collectionVO;
        }).filter(Objects::nonNull).sorted(Comparator.comparing(CommodityCollectionVO::getValidStatus).reversed()).collect(Collectors.toList());
    }

    @Override
    protected String description() {
        return "\u7528\u6237\u6536\u85cf\u5217\u8868";
    }

    @Override
    public Class<UserCollectionCommodityListParam> support() {
        return UserCollectionCommodityListParam.class;
    }
}

