/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.commodity.list.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.CommodityListItemResult;
import com.bxm.fossicker.commodity.model.dto.HdkWellChoseCommodityResult;
import com.bxm.fossicker.commodity.model.dto.Index;
import com.bxm.fossicker.commodity.model.param.CommodityDetailQueryParam;
import com.bxm.fossicker.commodity.model.param.WellChoseCommodityListParam;
import com.bxm.fossicker.commodity.model.vo.CategoryCommodityListItem;
import com.bxm.fossicker.commodity.service.commodity.list.AbstractCommodityListService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WellChoseCommodityListService
extends AbstractCommodityListService<CategoryCommodityListItem, WellChoseCommodityListParam> {
    @Autowired
    private CommodityInfoProperties commodityInfoProperties;

    @Override
    protected List<CategoryCommodityListItem> doGetCommodityList(WellChoseCommodityListParam param) {
        List<HdkWellChoseCommodityResult> searchResults = this.getHdkWellChoseCommodityFromApi(param);
        return searchResults.stream().map(p -> {
            CommodityDetailQueryParam queryParam = this.initCommodityDetailQueryParam(param, p.getItemId());
            queryParam.setQueryLocalOnly(true);
            queryParam.setValidateCouponPriceInfo(true);
            CommodityListItemResult result = this.commodityListItemBaseInfo(queryParam);
            if (!this.checkCommodityListBaseItemSuccess(result)) {
                return null;
            }
            CategoryCommodityListItem listItem = new CategoryCommodityListItem();
            BeanUtils.copyProperties((Object)result.getListItem(), (Object)listItem);
            if (Objects.nonNull(p.getDeposit())) {
                listItem.setHandsel(p.getDeposit());
            }
            return listItem;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<HdkWellChoseCommodityResult> getHdkWellChoseCommodityFromApi(WellChoseCommodityListParam param) {
        TreeMap<String, String> hdkMap = new TreeMap<String, String>();
        hdkMap.put("apikey", this.commodityInfoProperties.getHdkCommodityAppKey());
        hdkMap.put("sale_type", "1");
        hdkMap.put("item_type", "1");
        hdkMap.put("min_id", "1");
        hdkMap.put("back", "100");
        String hdkStr = "";
        try {
            hdkStr = OkHttpUtils.get((String)this.commodityInfoProperties.getHdkRankListUrl(), hdkMap);
            if (StringUtils.isBlank((String)hdkStr) || hdkStr.length() < 5) {
                for (int i = 1; i <= 3 && (hdkStr = OkHttpUtils.get((String)this.commodityInfoProperties.getHdkRankListUrl(), hdkMap)).length() <= 5; ++i) {
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u8bf7\u6c42\u597d\u5355\u5e93\u63a5\u53e3\u5931\u8d25", (Throwable)e);
        }
        if (StringUtils.isBlank((String)hdkStr)) {
            return Lists.newArrayList();
        }
        JSONObject hdkJson = JSONObject.parseObject((String)hdkStr);
        List<HdkWellChoseCommodityResult> results = Lists.newArrayList();
        if (Objects.nonNull(hdkJson) && Objects.nonNull(hdkJson.getInteger("code")) && hdkJson.getInteger("code") == 1) {
            JSONArray hdkArray = JSONArray.parseArray((String)hdkJson.getString("data"));
            for (int i = 0; i < hdkArray.size(); ++i) {
                JSONObject job = hdkArray.getJSONObject(i);
                HdkWellChoseCommodityResult result = new HdkWellChoseCommodityResult();
                result.setItemId(job.getLong("itemid"));
                result.setDeposit(job.getDouble("deposit"));
                results.add(result);
            }
        }
        Index index = this.getIndex(param.getPageOn(), param.getPageSize(), results.size());
        results = results.subList(index.getStart(), index.getEnd());
        return results;
    }

    @Override
    protected String description() {
        return "\u7cbe\u9009\u5217\u8868";
    }

    @Override
    public Class<WellChoseCommodityListParam> support() {
        return WellChoseCommodityListParam.class;
    }
}

