/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.externel.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.common.utils.SignMD5Util;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.bxm.fossicker.commodity.model.dto.DtkCommodityDetailDataDTO;
import com.bxm.fossicker.commodity.model.dto.DtkResultDTO;
import com.bxm.fossicker.commodity.service.externel.DtkCommodityService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DtkCommodityServiceImpl
implements DtkCommodityService {
    private static final Logger log = LoggerFactory.getLogger(DtkCommodityServiceImpl.class);
    @Autowired
    private CommodityInfoProperties commodityInfoProperties;

    @Override
    public CommodityDetailDTO getCommodityDetail(Long goodsId) {
        TreeMap<String, Object> paramMap = new TreeMap<String, Object>();
        paramMap.put("version", this.commodityInfoProperties.getDtkCommodityVersion());
        paramMap.put("appKey", this.commodityInfoProperties.getDtkCommodityAppKey());
        paramMap.put("goodsId", goodsId.toString());
        paramMap.put("sign", SignMD5Util.getSignStr(paramMap, (String)this.commodityInfoProperties.getDtkCommodityAppSecret()));
        DtkResultDTO resultDTO = this.queryDtkCommodityList(this.commodityInfoProperties.getDtkCommodityDetailUrl(), paramMap);
        if (DtkResultDTO.isFailed((DtkResultDTO)resultDTO)) {
            log.error("\u8bf7\u6c42\u5927\u6dd8\u5ba2\u5546\u54c1\u8be6\u60c5\u63a5\u53e3\u5931\u8d25");
            return null;
        }
        DtkCommodityDetailDataDTO dtkInfo = (DtkCommodityDetailDataDTO)JSON.parseObject((String)resultDTO.getData().toString(), DtkCommodityDetailDataDTO.class);
        ArrayList<String> picList = new ArrayList<String>();
        picList.add(dtkInfo.getMainPic());
        return CommodityDetailDTO.builder().goodsId(goodsId).reservePrice(dtkInfo.getOriginalPrice()).commodityTitle(dtkInfo.getTitle()).salesNum(Integer.valueOf(dtkInfo.getMonthSales())).commodityScore(Objects.toString(dtkInfo.getDescScore(), null)).sellerScore(Objects.toString(dtkInfo.getShipScore(), null)).logisticsScore(Objects.toString(dtkInfo.getServiceScore(), null)).imgUrlList(picList).shopName(dtkInfo.getShopName()).recommendContent(dtkInfo.getDesc()).shopType(Integer.valueOf(dtkInfo.getShopType())).build();
    }

    private DtkResultDTO queryDtkCommodityList(String queryUrl, Map<String, Object> queryParamMap) {
        DtkResultDTO dtkResultDTO = null;
        String resultStr = null;
        for (int tryTimes = 1; tryTimes < 3; ++tryTimes) {
            try {
                resultStr = OkHttpUtils.get((String)queryUrl, queryParamMap);
            }
            catch (IOException e) {
                log.error("\u6839\u636e\u53c2\u6570\u8bf7\u6c42\u5927\u6dd8\u5ba2\u5546\u54c1\u5217\u8868\u5f02\u5e38,\u8bf7\u6c42\u53c2\u6570:{},\u5f02\u5e38:{}", (Object)JSON.toJSONString(queryParamMap), (Object)e);
            }
            if (!StringUtils.isBlank((CharSequence)resultStr) && null != (dtkResultDTO = (DtkResultDTO)JSON.parseObject((String)resultStr, DtkResultDTO.class)) && 0 == dtkResultDTO.getCode()) break;
        }
        return dtkResultDTO;
    }
}

