/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.externel.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.HdkCommissionDataDTO;
import com.bxm.fossicker.commodity.model.dto.HdkCommodityDetailDataDTO;
import com.bxm.fossicker.commodity.model.dto.HdkResultDTO;
import com.bxm.fossicker.commodity.service.externel.HdkCommodityService;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HdkCommodityServiceImpl
implements HdkCommodityService {
    private static final Logger log = LoggerFactory.getLogger(HdkCommodityServiceImpl.class);
    @Autowired
    private CommodityInfoProperties commodityInfoProperties;

    @Override
    public HdkCommissionDataDTO getCommissionAndCoupon(Long goodsId, String pid) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("apikey", this.commodityInfoProperties.getHdkCommodityAppKey());
        paramMap.put("itemid", goodsId.toString());
        paramMap.put("pid", pid);
        String httpResult = this.queryHttpPostWithRetry(this.commodityInfoProperties.getHdkCommodityUrl(), paramMap);
        if (StringUtils.isBlank((String)httpResult)) {
            log.error("\u8bf7\u6c42\u9ad8\u4f63\u63a5\u53e3\u5931\u8d25,\u5546\u54c1id\u4e3a:{}", (Object)goodsId);
            return null;
        }
        HdkResultDTO hdkResultDTO = (HdkResultDTO)JSON.parseObject((String)httpResult, HdkResultDTO.class);
        if (HdkResultDTO.isFailed((HdkResultDTO)hdkResultDTO)) {
            log.error("\u8bf7\u6c42\u9ad8\u4f63\u63a5\u53e3\u5931\u8d25,\u5546\u54c1id\u4e3a:{},\u9519\u8bef\u4fe1\u606f\u4e3a:{}", (Object)goodsId, (Object)hdkResultDTO.getMsg());
            return null;
        }
        return (HdkCommissionDataDTO)JSON.parseObject((String)hdkResultDTO.getData().toString(), HdkCommissionDataDTO.class);
    }

    @Override
    public Double getPriceInfo(Long goodsId) {
        if (null == goodsId) {
            log.error("\u8bf7\u6c42\u5546\u54c1\u4ef7\u683c\u4fe1\u606f,\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
            return null;
        }
        String url = this.commodityInfoProperties.getHdkCommodityDetailUrl();
        String finalUrl = MessageFormat.format(url, this.commodityInfoProperties.getHdkCommodityAppKey(), goodsId.toString());
        String httpResult = null;
        try {
            httpResult = OkHttpUtils.get((String)finalUrl);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (StringUtils.isBlank((String)httpResult)) {
            log.error("\u8bf7\u6c42\u597d\u5355\u5e93\u6570\u636e\u4e3a\u7a7a,\u8bf7\u6c42url:{}", (Object)url);
            return null;
        }
        HdkResultDTO hdkResultDTO = (HdkResultDTO)JSONObject.parseObject((String)httpResult, HdkResultDTO.class);
        if (HdkResultDTO.isFailed((HdkResultDTO)hdkResultDTO)) {
            log.error("\u8bf7\u6c42\u597d\u5355\u5e93\u6570\u636e\u5931\u8d25,\u8bf7\u6c42url:{},\u9519\u8bef\u4fe1\u606f\u4e3a:{}", (Object)finalUrl, (Object)hdkResultDTO.getMsg());
            return null;
        }
        HdkCommodityDetailDataDTO hdkCommodityDetailDataDTO = (HdkCommodityDetailDataDTO)JSONObject.parseObject((String)hdkResultDTO.getData().toString(), HdkCommodityDetailDataDTO.class);
        return Double.valueOf(hdkCommodityDetailDataDTO.getItemprice());
    }

    private String queryHttpPostWithRetry(String queryUrl, Map<String, Object> queryParamMap) {
        String resultStr = null;
        for (int tryTimes = 1; tryTimes < 3; ++tryTimes) {
            try {
                resultStr = OkHttpUtils.postForm((String)queryUrl, queryParamMap);
            }
            catch (Exception e) {
                log.error("\u6839\u636e\u53c2\u6570\u8bf7\u6c42http\u63a5\u53e3\u5f02\u5e38,\u8bf7\u6c42\u53c2\u6570:{},\u5f02\u5e38:{}", (Object)JSON.toJSONString(queryParamMap), (Object)e);
            }
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)resultStr)) continue;
            return resultStr;
        }
        return resultStr;
    }
}

