/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.externel.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.CommodityDetailDTO;
import com.bxm.fossicker.commodity.service.externel.TbCommodityService;
import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.request.TbkActivitylinkGetRequest;
import com.taobao.api.request.TbkDgMaterialOptionalRequest;
import com.taobao.api.request.TbkItemInfoGetRequest;
import com.taobao.api.request.TbkItemRecommendGetRequest;
import com.taobao.api.request.TbkJuTqgGetRequest;
import com.taobao.api.request.TbkTpwdCreateRequest;
import com.taobao.api.response.TbkActivitylinkGetResponse;
import com.taobao.api.response.TbkDgMaterialOptionalResponse;
import com.taobao.api.response.TbkItemInfoGetResponse;
import com.taobao.api.response.TbkItemRecommendGetResponse;
import com.taobao.api.response.TbkJuTqgGetResponse;
import com.taobao.api.response.TbkTpwdCreateResponse;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TbCommodityServiceImpl
implements TbCommodityService {
    private static final Logger log = LoggerFactory.getLogger(TbCommodityServiceImpl.class);
    @Autowired
    private CommodityInfoProperties commodityInfoProperties;

    @Override
    public CommodityDetailDTO getCommodityDetail(Long goodsId) {
        TbkItemInfoGetResponse rsp;
        DefaultTaobaoClient client = new DefaultTaobaoClient(this.commodityInfoProperties.getTbCommodityUrl(), this.commodityInfoProperties.getTbCommodityAppKey(), this.commodityInfoProperties.getTbCommodityAppSecret());
        TbkItemInfoGetRequest req = new TbkItemInfoGetRequest();
        req.setNumIids(goodsId.toString());
        try {
            rsp = (TbkItemInfoGetResponse)client.execute((TaobaoRequest)req);
        }
        catch (ApiException e) {
            log.error("\u4ece\u6dd8\u5b9d\u63a5\u53e3\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u5f02\u5e38,\u5546\u54c1id\u4e3a:{},\u5f02\u5e38\u4e3a:", (Object)goodsId, (Object)e);
            return null;
        }
        if (null == rsp || !rsp.isSuccess() || CollectionUtils.isEmpty((Collection)rsp.getResults())) {
            log.error("\u4ece\u6dd8\u5b9d\u63a5\u53e3\u83b7\u53d6\u5230\u7684\u5546\u54c1\u5217\u8868\u4fe1\u606f\u4e3a\u7a7a,\u5546\u54c1id\u4e3a:{}", (Object)goodsId);
            return null;
        }
        TbkItemInfoGetResponse.NTbkItem tbInfo = (TbkItemInfoGetResponse.NTbkItem)rsp.getResults().get(0);
        return this.convertCommodityDetail(tbInfo);
    }

    @Override
    public List<CommodityDetailDTO> getCommodityDetailList(String goodsIdArray) {
        TbkItemInfoGetResponse rsp;
        DefaultTaobaoClient client = new DefaultTaobaoClient(this.commodityInfoProperties.getTbCommodityUrl(), this.commodityInfoProperties.getTbCommodityAppKey(), this.commodityInfoProperties.getTbCommodityAppSecret());
        TbkItemInfoGetRequest req = new TbkItemInfoGetRequest();
        req.setNumIids(goodsIdArray);
        try {
            rsp = (TbkItemInfoGetResponse)client.execute((TaobaoRequest)req);
        }
        catch (ApiException e) {
            log.error("\u4ece\u6dd8\u5b9d\u63a5\u53e3\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u5f02\u5e38,\u5546\u54c1id\u4e32\u4e3a:{},\u5f02\u5e38\u4e3a:", (Object)goodsIdArray, (Object)e);
            return null;
        }
        if (null == rsp || !rsp.isSuccess() || CollectionUtils.isEmpty((Collection)rsp.getResults())) {
            log.error("\u4ece\u6dd8\u5b9d\u63a5\u53e3\u83b7\u53d6\u5230\u7684\u5546\u54c1\u5217\u8868\u4fe1\u606f\u4e3a\u7a7a");
            return null;
        }
        List tbInfoList = rsp.getResults();
        return tbInfoList.stream().map(this::convertCommodityDetail).collect(Collectors.toList());
    }

    @Override
    public String createTaoWord(String url, String logUrl, String text) {
        TbkTpwdCreateResponse rsp;
        DefaultTaobaoClient client = new DefaultTaobaoClient(this.commodityInfoProperties.getTbCommodityUrl(), this.commodityInfoProperties.getTbCommodityAppKey(), this.commodityInfoProperties.getTbCommodityAppSecret());
        TbkTpwdCreateRequest req = new TbkTpwdCreateRequest();
        req.setText(text);
        req.setUrl(url);
        req.setLogo(logUrl);
        try {
            rsp = (TbkTpwdCreateResponse)client.execute((TaobaoRequest)req);
        }
        catch (ApiException e) {
            log.error("\u521b\u5efa\u6dd8\u53e3\u4ee4\u5f02\u5e38", (Throwable)e);
            return null;
        }
        if (null == rsp || !rsp.isSuccess() || null == rsp.getData()) {
            log.error("\u521b\u5efa\u6dd8\u53e3\u4ee4\u5931\u8d25, rsp: {}", (Object)rsp);
            return null;
        }
        return rsp.getData().getModel();
    }

    @Override
    public TbkJuTqgGetResponse getTqgCommodity(TbkJuTqgGetRequest req) {
        TbkJuTqgGetResponse rsp;
        DefaultTaobaoClient client = new DefaultTaobaoClient(this.commodityInfoProperties.getTbCommodityUrl(), this.commodityInfoProperties.getTbCommodityAppKey(), this.commodityInfoProperties.getTbCommodityAppSecret());
        try {
            rsp = (TbkJuTqgGetResponse)client.execute((TaobaoRequest)req);
        }
        catch (ApiException e) {
            log.error("\u8bf7\u6c42\u6dd8\u62a2\u8d2d\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return rsp;
    }

    @Override
    public TbkDgMaterialOptionalResponse getCommodityListByName(TbkDgMaterialOptionalRequest req) {
        TbkDgMaterialOptionalResponse rsp;
        DefaultTaobaoClient client = new DefaultTaobaoClient(this.commodityInfoProperties.getTbCommodityUrl(), this.commodityInfoProperties.getTbCommodityAppKey(), this.commodityInfoProperties.getTbCommodityAppSecret());
        try {
            rsp = (TbkDgMaterialOptionalResponse)client.execute((TaobaoRequest)req);
        }
        catch (ApiException e) {
            log.error("\u4ece\u6dd8\u5b9d\u63a5\u53e3\u6309\u641c\u7d22\u540d\u83b7\u53d6\u5546\u54c1\u5217\u8868\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return rsp;
    }

    @Override
    public TbkItemRecommendGetResponse getRecommendCommodity(TbkItemRecommendGetRequest req) {
        TbkItemRecommendGetResponse rsp;
        DefaultTaobaoClient client = new DefaultTaobaoClient(this.commodityInfoProperties.getTbCommodityUrl(), this.commodityInfoProperties.getTbCommodityAppKey(), this.commodityInfoProperties.getTbCommodityAppSecret());
        try {
            rsp = (TbkItemRecommendGetResponse)client.execute((TaobaoRequest)req);
        }
        catch (ApiException e) {
            log.error("\u4ece\u6dd8\u5b9d\u83b7\u53d6\u63a8\u8350\u5546\u54c1\u5f02\u5e38:", (Throwable)e);
            return null;
        }
        return rsp;
    }

    private CommodityDetailDTO convertCommodityDetail(TbkItemInfoGetResponse.NTbkItem tbInfo) {
        CommodityDetailDTO commodityDetailDTO = CommodityDetailDTO.builder().goodsId(tbInfo.getNumIid()).reservePrice(Double.valueOf(tbInfo.getZkFinalPrice())).mainPic(tbInfo.getPictUrl()).commodityTitle(tbInfo.getTitle()).salesNum(null == tbInfo.getVolume() ? null : Integer.valueOf(tbInfo.getVolume().intValue())).shopName(tbInfo.getNick()).shopType(null == tbInfo.getUserType() ? null : Integer.valueOf(tbInfo.getUserType().intValue())).build();
        return commodityDetailDTO;
    }

    @Override
    public TbkActivitylinkGetResponse getTaoBaoUnion(TbkActivitylinkGetRequest req) {
        TbkActivitylinkGetResponse res;
        DefaultTaobaoClient client = new DefaultTaobaoClient(this.commodityInfoProperties.getTbCommodityUrl(), this.commodityInfoProperties.getTblmCommodityAppKey(), this.commodityInfoProperties.getTblmCommodityAppSecret());
        try {
            res = (TbkActivitylinkGetResponse)client.execute((TaobaoRequest)req);
            if (Objects.isNull(res.getBizErrorCode()) || !Objects.equals(res.getBizErrorCode(), 0L)) {
                log.error("\u8bf7\u6c42\u6dd8\u5b9d\u8054\u76df\u5931\u8d25\uff0c\u8bf7\u6c42\u6570\u636e: {}\uff0c \u8fd4\u56de\u6570\u636e: {}", (Object)JSON.toJSONString((Object)req), (Object)JSON.toJSONString((Object)res));
            }
        }
        catch (ApiException e) {
            log.error("\u8bf7\u6c42\u6dd8\u5b9d\u8054\u76df\u83b7\u53d6\u8df3\u8f6c\u94fe\u63a5\u5f02\u5e38:", (Throwable)e);
            return null;
        }
        return res;
    }
}

