/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.externel.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.commodity.common.enums.CommoditySortTypeEnum;
import com.bxm.fossicker.commodity.common.utils.OkHttpUtils;
import com.bxm.fossicker.commodity.common.utils.SignMD5Util;
import com.bxm.fossicker.commodity.config.CommodityInfoProperties;
import com.bxm.fossicker.commodity.model.dto.WyCommissionDataDTO;
import com.bxm.fossicker.commodity.model.dto.WyQueryResultDTO;
import com.bxm.fossicker.commodity.model.dto.WySearchCommodityInfoDTO;
import com.bxm.fossicker.commodity.model.dto.WySearchResultDTO;
import com.bxm.fossicker.commodity.model.param.CommoditySearchParam;
import com.bxm.fossicker.commodity.model.param.GuessCommodityQueryParam;
import com.bxm.fossicker.commodity.service.externel.QueryWithRetryService;
import com.bxm.fossicker.commodity.service.externel.WyCommodityService;
import com.bxm.newidea.component.apollo.i18n.MessageHelper;
import com.bxm.newidea.component.tools.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WyCommodityServiceImpl
implements WyCommodityService {
    private static final Logger log = LoggerFactory.getLogger(WyCommodityServiceImpl.class);
    private final QueryWithRetryService queryWithRetryService;
    private final CommodityInfoProperties commodityInfoProperties;
    private static String SUCCESS = "0";
    private static String SEARCH_WITHOUT_RES = "15";

    @Autowired
    public WyCommodityServiceImpl(QueryWithRetryService queryWithRetryService, CommodityInfoProperties commodityInfoProperties) {
        this.queryWithRetryService = queryWithRetryService;
        this.commodityInfoProperties = commodityInfoProperties;
    }

    @Override
    public WySearchResultDTO searchCommodity(CommoditySearchParam commonditySearchParam) {
        String searchResultStr;
        String queryUrl = this.commodityInfoProperties.getWySearchUrl();
        Map<String, Object> searchParam = this.assembleSearchParam(commonditySearchParam);
        try {
            searchResultStr = OkHttpUtils.get((String)queryUrl, searchParam);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((CharSequence)searchResultStr)) {
            return null;
        }
        WyQueryResultDTO wyQueryResultDTO = (WyQueryResultDTO)JSON.parseObject((String)searchResultStr, WyQueryResultDTO.class);
        if (Objects.isNull(wyQueryResultDTO)) {
            log.info("\u7ef4\u6613\u67e5\u8be2\u63a5\u53e3\u4e0d\u5b58\u5728\u6570\u636e\uff0c\u53c2\u6570\uff1a[{}]\uff0c\u7ed3\u679c:[{}]", (Object)commonditySearchParam, (Object)searchResultStr);
            return null;
        }
        if (SUCCESS.equals(wyQueryResultDTO.getError())) {
            WySearchResultDTO result = WySearchResultDTO.builder().searchType(wyQueryResultDTO.getSearchType()).commodityList(this.getResultList(wyQueryResultDTO)).build();
            if (StringUtils.isBlank((CharSequence)result.getSearchType())) {
                result.setSearchType("2");
            }
            return result;
        }
        if (SEARCH_WITHOUT_RES.equals(wyQueryResultDTO.getError())) {
            log.info("\u641c\u7d22\u7684\u5546\u54c1\u5728\u7ef4\u6613\u5e73\u53f0\u4e0d\u5b58\u5728\u6dd8\u5ba2\u5546\u54c1\uff0c\u641c\u7d22\u53c2\u6570\uff1a{}", (Object)commonditySearchParam);
            String msg = MessageHelper.getMessageWithDefault((String)"commodity.weiyi.search-without-res", (String)"\u8be5\u5b9d\u8d1d\u5df2\u4e0b\u67b6\u6216\u975e\u6dd8\u5ba2\u5b9d\u8d1d");
            return WySearchResultDTO.builder().msg(msg).searchType("3").build();
        }
        log.warn("\u7ef4\u6613\u641c\u7d22\u63a5\u53e3\u5f02\u5e38\uff0c\u641c\u7d22\u53c2\u6570\uff1a{},\u641c\u7d22\u7ed3\u679c\uff1a{}", (Object)commonditySearchParam, (Object)searchResultStr);
        return null;
    }

    @Override
    public List<WySearchCommodityInfoDTO> guessLike(GuessCommodityQueryParam guessCommodityQueryParam) {
        String searchResultStr;
        String queryUrl = this.commodityInfoProperties.getWyGuessUrl();
        Map<String, Object> guessParam = this.assembleGuessParam(guessCommodityQueryParam);
        try {
            searchResultStr = this.queryWithRetryService.doGetWithRetry(queryUrl, guessParam);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5f02\u5e38,\u8bf7\u6c42\u8def\u5f84\u4e3a:{}, \u8bf7\u6c42\u53c2\u6570\u4e3a:{}, \u5f02\u5e38\u4e3a:{}", new Object[]{queryUrl, JSON.toJSONString(guessParam), e});
            return null;
        }
        WyQueryResultDTO wyGuessResultDTO = (WyQueryResultDTO)JSON.parseObject((String)searchResultStr, WyQueryResultDTO.class);
        if (Objects.isNull(wyGuessResultDTO) || !SUCCESS.equals(wyGuessResultDTO.getError()) || Objects.isNull(wyGuessResultDTO.getData())) {
            return null;
        }
        return JSONArray.parseArray((String)wyGuessResultDTO.getData().toString(), WySearchCommodityInfoDTO.class);
    }

    @Override
    public WyCommissionDataDTO getCommissionInfo(Long goodsId) {
        String searchResultStr;
        String queryUrl = this.commodityInfoProperties.getWyCommissionUrl();
        Map<String, Object> paramMap = this.assembleCommissionParam(goodsId);
        try {
            searchResultStr = this.queryWithRetryService.doGetWithRetry(queryUrl, paramMap);
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5f02\u5e38,\u8bf7\u6c42\u8def\u5f84\u4e3a:{}, \u8bf7\u6c42\u53c2\u6570\u4e3a:{}, \u5f02\u5e38\u4e3a:{}", new Object[]{queryUrl, JSON.toJSONString(paramMap), e});
            return null;
        }
        WyQueryResultDTO wyCommissionResultDTO = (WyQueryResultDTO)JSON.parseObject((String)searchResultStr, WyQueryResultDTO.class);
        if (Objects.isNull(wyCommissionResultDTO) || Objects.isNull(wyCommissionResultDTO.getData())) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("wy\u83b7\u53d6\u9ad8\u4f63\u4fe1\u606f\uff1a[{}]", JSONObject.toJSON((Object)wyCommissionResultDTO));
        }
        return (WyCommissionDataDTO)JSON.parseObject((String)wyCommissionResultDTO.getData().toString(), WyCommissionDataDTO.class);
    }

    private Map<String, Object> assembleSearchParam(CommoditySearchParam commoditySearchParam) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("para", commoditySearchParam.getCommodityName());
        paramMap.put("vekey", "V00002250Y21499601");
        paramMap.put("pagesize", commoditySearchParam.getPageSize());
        paramMap.put("page", commoditySearchParam.getPageNum());
        paramMap.put("coupon", commoditySearchParam.getCouponFlag());
        if (StringUtils.isNotBlank((CharSequence)commoditySearchParam.getSortType())) {
            paramMap.put("sort", CommoditySortTypeEnum.getTypeByCode((String)commoditySearchParam.getSortType()));
        }
        if (null != commoditySearchParam.getPriceLowerLimit()) {
            paramMap.put("start_price", commoditySearchParam.getPriceLowerLimit());
        }
        if (null != commoditySearchParam.getPriceUpperLimit()) {
            paramMap.put("end_price", commoditySearchParam.getPriceUpperLimit());
        }
        return paramMap;
    }

    private Map<String, Object> assembleGuessParam(GuessCommodityQueryParam guessCommodityQueryParam) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        paramMap.put("vekey", "V00002250Y21499601");
        paramMap.put("device_type", guessCommodityQueryParam.getDeviceType());
        paramMap.put("device_value", StringUtils.isNotBlank((CharSequence)guessCommodityQueryParam.getDeviceNo()) ? SignMD5Util.MD5((String)guessCommodityQueryParam.getDeviceNo()) : "");
        paramMap.put("device_encrypt", "MD5");
        paramMap.put("page_no", guessCommodityQueryParam.getPageNum());
        paramMap.put("page_size", guessCommodityQueryParam.getPageSize());
        return paramMap;
    }

    private Map<String, Object> assembleCommissionParam(Long goodsId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("para", goodsId);
        paramMap.put("vekey", "V00002250Y21499601");
        return paramMap;
    }

    private List<WySearchCommodityInfoDTO> getResultList(WyQueryResultDTO wyQueryResultDTO) {
        if ("1".equals(wyQueryResultDTO.getSearchType())) {
            return wyQueryResultDTO.getResultList();
        }
        if ("2".equals(wyQueryResultDTO.getSearchType())) {
            ArrayList<WySearchCommodityInfoDTO> resultList = new ArrayList<WySearchCommodityInfoDTO>();
            resultList.add((WySearchCommodityInfoDTO)JSON.parseObject((String)wyQueryResultDTO.getData().toString(), WySearchCommodityInfoDTO.class));
            return resultList;
        }
        return null;
    }
}

