/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.domain.CommodityInfoMapper;
import com.bxm.fossicker.commodity.domain.CommoditySearchLogMapper;
import com.bxm.fossicker.commodity.model.dto.CommoditySearchDTO;
import com.bxm.fossicker.commodity.service.BlackCommodityService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BlackCommodityServiceImpl
implements BlackCommodityService {
    @Resource
    private CommoditySearchLogMapper commodityMapper;
    @Resource
    private CommodityInfoMapper commodityInfoMapper;
    private Set<String> blackIds = Sets.newHashSet();
    private long lastSyncMils = 0L;
    private static final Long EXPIRED_MILS = 30000L;

    @Override
    public <T> List rejectCommodity(List<T> list) {
        List goodsIdList = this.commodityMapper.getPoolInfo(3);
        ArrayList<T> resultList = new ArrayList<T>();
        for (T object : list) {
            String goodsId;
            if (!(object instanceof CommoditySearchDTO) || goodsIdList.contains(goodsId = ((CommoditySearchDTO)object).getGoodsId().toString())) continue;
            resultList.add(object);
        }
        return resultList;
    }

    @Override
    public boolean isBlackCommodity(Long goodsId) {
        if (null == goodsId) {
            return false;
        }
        long currentMils = System.currentTimeMillis();
        if (this.lastSyncMils < currentMils) {
            List swapBlackIds = this.commodityInfoMapper.getPoolInfo(Long.valueOf(3L));
            this.lastSyncMils = currentMils + EXPIRED_MILS;
            this.blackIds = new HashSet<String>(swapBlackIds);
        }
        return this.blackIds.contains(goodsId.toString());
    }
}

