/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.domain.CommodityBrowseFlowMapper;
import com.bxm.fossicker.commodity.facade.BrowseFlowFacadeService;
import com.bxm.fossicker.commodity.model.param.BrowseCommodityParam;
import com.bxm.fossicker.commodity.model.vo.BrowseCountVo;
import com.bxm.fossicker.commodity.model.vo.CommodityBrowseFlow;
import com.bxm.fossicker.commodity.service.BrowseFlowService;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BrowseFlowServiceImpl
implements BrowseFlowService,
BrowseFlowFacadeService {
    private static final Logger log = LogManager.getLogger(BrowseFlowServiceImpl.class);
    private final CommodityBrowseFlowMapper browseFlowMapper;
    private final SequenceCreater sequenceCreater;

    @Autowired
    public BrowseFlowServiceImpl(CommodityBrowseFlowMapper browseFlowMapper, SequenceCreater sequenceCreater) {
        this.browseFlowMapper = browseFlowMapper;
        this.sequenceCreater = sequenceCreater;
    }

    public Map<Long, Integer> getTotalBrowseMap(List<Long> userIdList) {
        return this.browseFlowMapper.getTotalCountByList(userIdList).stream().collect(Collectors.toMap(BrowseCountVo::getUserId, BrowseCountVo::getTotalBrowseCount));
    }

    @Override
    public Boolean isBrowseCommodityByToday(Long commodityId, Long userId) {
        CommodityBrowseFlow commodityBrowseFlow = new CommodityBrowseFlow();
        commodityBrowseFlow.setUserId(userId);
        commodityBrowseFlow.setGoodsId(commodityId);
        List commodityBrowseFlowList = this.browseFlowMapper.getTodayRecordBySelf(commodityBrowseFlow);
        return !CollectionUtils.isEmpty((Collection)commodityBrowseFlowList);
    }

    @Override
    public Boolean addBrowseCommodityRecord(BrowseCommodityParam browseCommodityParam) {
        CommodityBrowseFlow commodityBrowseFlowEntity = new CommodityBrowseFlow();
        commodityBrowseFlowEntity.setId(this.sequenceCreater.nextLongId());
        commodityBrowseFlowEntity.setUserId(browseCommodityParam.getUserId());
        commodityBrowseFlowEntity.setGoodsId(browseCommodityParam.getGoodsId());
        commodityBrowseFlowEntity.setBrowseType(Integer.valueOf(1));
        commodityBrowseFlowEntity.setCreateTime(new Date());
        this.browseFlowMapper.addBrowseRecord(commodityBrowseFlowEntity);
        return true;
    }

    @Override
    public Boolean addBrowseShareCommodityRecord(Long browseUserId, Long shareUserId, Long goodsId) {
        CommodityBrowseFlow commodityBrowseFlowEntity = new CommodityBrowseFlow();
        commodityBrowseFlowEntity.setId(this.sequenceCreater.nextLongId());
        commodityBrowseFlowEntity.setUserId(browseUserId);
        commodityBrowseFlowEntity.setShareUserId(shareUserId);
        commodityBrowseFlowEntity.setGoodsId(goodsId);
        commodityBrowseFlowEntity.setBrowseType(Integer.valueOf(2));
        commodityBrowseFlowEntity.setCreateTime(new Date());
        this.browseFlowMapper.addBrowseRecord(commodityBrowseFlowEntity);
        return true;
    }

    public Integer getUserBrowseRecordToday(Long userId) {
        return this.browseFlowMapper.getTotalRecordToday(userId);
    }
}

