/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.common.enums.CommodityFavoriteStatusEnum;
import com.bxm.fossicker.commodity.domain.CommodityFavoriteMapper;
import com.bxm.fossicker.commodity.model.param.CollectCommodityParam;
import com.bxm.fossicker.commodity.model.param.CommodityListParam;
import com.bxm.fossicker.commodity.model.param.UserCollectionCommodityListParam;
import com.bxm.fossicker.commodity.model.vo.CommodityCollectionVO;
import com.bxm.fossicker.commodity.model.vo.CommodityFavorite;
import com.bxm.fossicker.commodity.service.CommodityCollectService;
import com.bxm.fossicker.commodity.service.commodity.list.CommodityListServiceProxy;
import com.bxm.newidea.component.uuid.SequenceCreater;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommodityCollectServiceImpl
implements CommodityCollectService {
    private static final Logger log = LoggerFactory.getLogger(CommodityCollectServiceImpl.class);
    @Autowired
    private CommodityFavoriteMapper commodityFavoriteMapper;
    @Autowired
    private SequenceCreater sequenceCreater;
    @Autowired
    private CommodityListServiceProxy commodityListServiceProxy;

    @Override
    public Integer getCollectStatus(Long commodityId, Long userId) {
        CommodityFavorite commodityFavoriteEntity = new CommodityFavorite();
        commodityFavoriteEntity.setUserId(userId);
        commodityFavoriteEntity.setTid(commodityId.toString());
        Integer resultCount = this.commodityFavoriteMapper.getCollectStatus(commodityFavoriteEntity);
        return null != resultCount && resultCount > 0 ? CommodityFavoriteStatusEnum.FAVORITE_STATUS.getStatus() : CommodityFavoriteStatusEnum.NOT_FAVORITE_STATUS.getStatus();
    }

    @Override
    public Integer changeCollectStatus(CollectCommodityParam collectCommodityParam) {
        if (CommodityFavoriteStatusEnum.FAVORITE_STATUS.getStatus().equals(collectCommodityParam.getCollectStatus())) {
            CommodityFavorite insertEntity = new CommodityFavorite();
            insertEntity.setId(this.sequenceCreater.nextLongId());
            insertEntity.setTid(collectCommodityParam.getGoodsId());
            insertEntity.setUserId(collectCommodityParam.getUserId());
            insertEntity.setDeleteFlag(new Byte("0"));
            insertEntity.setCreateTime(new Date());
            this.commodityFavoriteMapper.insertSelective(insertEntity);
        } else {
            CommodityFavorite updateEntity = new CommodityFavorite();
            updateEntity.setTid(collectCommodityParam.getGoodsId());
            updateEntity.setUserId(collectCommodityParam.getUserId());
            this.commodityFavoriteMapper.notCollectStatus(updateEntity);
        }
        return 1;
    }

    @Override
    public List<CommodityCollectionVO> gerUserCollection(Long userId) {
        UserCollectionCommodityListParam param = new UserCollectionCommodityListParam();
        param.setUserId(userId);
        param.setQueryLabel(true);
        return this.commodityListServiceProxy.getCommodityList((CommodityListParam)param);
    }
}

