/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.commodity.service.impl;

import com.bxm.fossicker.commodity.common.dto.PlatformCommissionRateInfo;
import com.bxm.fossicker.commodity.common.utils.CommodityCalUtils;
import com.bxm.fossicker.commodity.model.dto.CommodityCouponInfoFromSuper;
import com.bxm.fossicker.commodity.model.dto.CommodityInfoDTO;
import com.bxm.fossicker.commodity.model.entry.CommodityInfo;
import com.bxm.fossicker.commodity.model.vo.CommodityCouponInfo;
import com.bxm.fossicker.commodity.service.CommodityCouponInfoService;
import com.bxm.fossicker.commodity.service.CommodityPriceInfoService;
import com.bxm.fossicker.commodity.service.commodity.info.CommodityInfoSourceProxyService;
import com.bxm.fossicker.constant.CommonCommodityRedisKey;
import com.bxm.fossicker.integration.dto.CommodityCouponInfoDTO;
import com.bxm.fossicker.integration.param.GetCouponInfoParam;
import com.bxm.fossicker.integration.service.CommoditySyncIntegrationService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommodityCouponInfoServiceImpl
implements CommodityCouponInfoService {
    private static final Logger log = LoggerFactory.getLogger(CommodityCouponInfoServiceImpl.class);
    @Autowired
    private CommoditySyncIntegrationService commoditySyncIntegrationService;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private CommodityInfoSourceProxyService commodityInfoSourceProxyService;
    @Autowired
    private CommodityPriceInfoService commodityPriceInfoService;

    @Override
    public CommodityCouponInfo getCommodityCouponInfo(GetCouponInfoParam param) {
        CommodityCouponInfo info = new CommodityCouponInfo();
        info.setGoodsId(param.getGoodsId());
        this.setSourceFromIfNecessary(param);
        CommodityCouponInfoDTO commodityCouponInfoDTO = this.commoditySyncIntegrationService.loadCouponInfoFromCache(param);
        if (Objects.nonNull(commodityCouponInfoDTO)) {
            info.setCouponUrl(param.isReplaceHttp2TbOpen() ? this.assembleCouponUrlByType(commodityCouponInfoDTO.getCouponUrl()) : commodityCouponInfoDTO.getCouponUrl());
        }
        return info;
    }

    private void setSourceFromIfNecessary(GetCouponInfoParam param) {
        KeyGenerator keyGenerator;
        CommodityInfo commodityInfo;
        if (Objects.isNull(param.getSourceFrom()) && Objects.nonNull(commodityInfo = (CommodityInfo)this.redisHashMapAdapter.get(keyGenerator = CommonCommodityRedisKey.LOCAL_COMMODITY_INFO.copy().appendKey((Object)(Math.abs(param.getGoodsId().hashCode()) % 10)), param.getGoodsId(), CommodityInfo.class))) {
            param.setSourceFrom(commodityInfo.getSoruce());
        }
    }

    @Override
    public String assembleCouponUrlByType(String couponUrl) {
        if (StringUtils.isBlank((String)couponUrl)) {
            return couponUrl;
        }
        return couponUrl.replace("https", "tbopen");
    }

    @Override
    public CommodityCouponInfoFromSuper getCouponInfo(Long goodsId, Long userId) {
        CommodityInfoDTO commodityInfoDTO = this.commodityInfoSourceProxyService.getCommodityDetail(goodsId);
        if (null == commodityInfoDTO) {
            log.error("\u83b7\u53d6\u5546\u54c1\u4e3a\u7a7a,\u5546\u54c1id:{}", (Object)goodsId);
            return null;
        }
        CommodityCouponInfoFromSuper resultInfo = new CommodityCouponInfoFromSuper();
        PlatformCommissionRateInfo cInfo = this.commodityPriceInfoService.getPlatformCommissionRateInfo(goodsId);
        if (null != cInfo) {
            Double commissionPrice = CommodityCalUtils.calCommissionForPlatformCommission((PlatformCommissionRateInfo)cInfo, (Double)commodityInfoDTO.getPlatformCommissionPrice());
            resultInfo.setCommissionPrice(commissionPrice);
            resultInfo.setCouponPrice(commodityInfoDTO.getCouponPrice());
            resultInfo.setCouponUrl(commodityInfoDTO.getCouponUrl());
        }
        return resultInfo;
    }
}

